/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.filespecs;

import java.io.File;
import org.apache.flex.compiler.filespecs.IFileSpecification;
import org.apache.flex.utils.FilenameNormalization;

public abstract class BaseFileSpecification
implements IFileSpecification {
    protected String path;

    public BaseFileSpecification(String path) {
        this.path = FilenameNormalization.normalize(path);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public File getFileHandle() {
        return new File(this.getPath());
    }

    @Override
    public long getLastModified() {
        File file = new File(this.getPath());
        if (file.exists()) {
            return file.lastModified();
        }
        return 0x7FFFFFFFFFFFFFFEL;
    }

    @Override
    public boolean isOpenDocument() {
        return false;
    }

    public String toString() {
        return this.getPath();
    }
}

