/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.as;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.flex.compiler.codegen.as.IASEmitter;
import org.apache.flex.compiler.codegen.as.IASWriter;
import org.apache.flex.compiler.internal.codegen.as.ASFilterWriter;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.visitor.as.IASBlockWalker;

public class ASWriter
implements IASWriter {
    private FlexJSProject project;
    private List<ICompilerProblem> problems;
    private ICompilationUnit compilationUnit;
    private boolean enableDebug;

    public ASWriter(FlexJSProject project, List<ICompilerProblem> problems, ICompilationUnit compilationUnit, boolean enableDebug) {
        this.project = project;
        this.problems = problems;
        this.compilationUnit = compilationUnit;
        this.enableDebug = enableDebug;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeTo(OutputStream out) {
        ASFilterWriter writer = this.project.getBackend().createWriterBuffer(this.project);
        IASEmitter emitter = this.project.getBackend().createEmitter(writer);
        IASBlockWalker walker = this.project.getBackend().createWalker(this.project, this.problems, emitter);
        walker.visitCompilationUnit(this.compilationUnit);
        System.out.println(writer.toString());
        try {
            out.write(writer.toString().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int writeTo(File out) throws FileNotFoundException, IOException {
        return 0;
    }
}

