/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.clients;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flex.compiler.clients.MXMLJSC;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.config.ConfigurationValue;
import org.apache.flex.compiler.exceptions.ConfigurationException;
import org.apache.flex.compiler.internal.config.annotations.Arguments;
import org.apache.flex.compiler.internal.config.annotations.Config;
import org.apache.flex.compiler.internal.config.annotations.FlexOnly;
import org.apache.flex.compiler.internal.config.annotations.InfiniteArguments;
import org.apache.flex.compiler.internal.config.annotations.Mapping;
import org.apache.flex.compiler.internal.mxml.MXMLNamespaceMapping;

public class JSConfiguration
extends Configuration {
    protected final List<String> targets = new ArrayList<String>();
    private boolean sourceMap = false;
    private final List<String> jsexternalLibraryPath = new ArrayList<String>();
    private final List<String> jslibraryPath = new ArrayList<String>();
    private Map<String, String> jsconfigVars;
    private String jsoutput;
    private List<MXMLNamespaceMapping> jsmanifestMappings;

    public List<String> getCompilerTargets() {
        if (this.targets.size() == 0) {
            this.targets.add(MXMLJSC.JSTargetType.JS_FLEX.getText());
        }
        return this.targets;
    }

    @Config(allowMultiple=true, isPath=false)
    @Mapping(value={"compiler", "targets"})
    @Arguments(value={"target"})
    @InfiniteArguments
    public void setCompilerTargets(ConfigurationValue cv, String[] targetlist) {
        this.targets.clear();
        for (String target : targetlist) {
            this.targets.add(target);
        }
    }

    @Config
    @Mapping(value={"js-output-type"})
    public void setJSOutputType(ConfigurationValue cv, String value) throws ConfigurationException {
        if (this.targets.size() > 0) {
            return;
        }
        this.targets.clear();
        this.targets.add(value);
    }

    public boolean getSourceMap() {
        return this.sourceMap;
    }

    @Config
    @Mapping(value={"source-map"})
    public void setSourceMap(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.sourceMap = value;
    }

    public List<String> getCompilerJsExternalLibraryPath() {
        return this.jsexternalLibraryPath;
    }

    @Config(allowMultiple=true, isPath=true)
    @Mapping(value={"compiler", "js-external-library-path"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setCompilerJsExternalLibraryPath(ConfigurationValue cv, String[] pathlist) throws ConfigurationException {
        ImmutableList pathElements = ImmutableList.copyOf((Object[])pathlist);
        ImmutableList resolvedPaths = this.expandTokens((Iterable)pathElements, this.locales, cv, !this.reportMissingCompilerLibraries);
        this.jsexternalLibraryPath.addAll((Collection<String>)resolvedPaths);
    }

    public List<String> getCompilerJsLibraryPath() {
        return this.jslibraryPath;
    }

    @Config(allowMultiple=true, isPath=true)
    @Mapping(value={"compiler", "js-library-path"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setCompilerJsLibraryPath(ConfigurationValue cv, String[] pathlist) throws ConfigurationException.CannotOpen {
        ImmutableList resolvedPaths = this.expandTokens(Arrays.asList(pathlist), this.locales, cv, !this.reportMissingCompilerLibraries);
        this.jslibraryPath.addAll((Collection<String>)resolvedPaths);
    }

    public Map<String, String> getCompilerDefine() {
        if (this.jsconfigVars != null) {
            return this.jsconfigVars;
        }
        return super.getCompilerDefine();
    }

    @Config(advanced=true, allowMultiple=true)
    @Arguments(value={"name", "value"})
    public void setJsCompilerDefine(ConfigurationValue cv, String name, String value) throws ConfigurationException {
        if (this.jsconfigVars == null) {
            this.jsconfigVars = new LinkedHashMap<String, String>();
        }
        this.jsconfigVars.put(name, value);
    }

    public String getOutput() {
        if (this.jsoutput != null) {
            return this.jsoutput;
        }
        return super.getOutput();
    }

    @Config
    @Arguments(value={"filename"})
    public void setJsOutput(ConfigurationValue val, String output) throws ConfigurationException {
        this.jsoutput = this.getOutputPath(val, output);
    }

    public String getJsLoadConfig() {
        return null;
    }

    @Config(allowMultiple=true)
    @Arguments(value={"filename"})
    public void setJsLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
    }

    public List<MXMLNamespaceMapping> getCompilerJsNamespacesManifestMappings() {
        return this.jsmanifestMappings;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"compiler", "js-namespaces", "namespace"})
    @Arguments(value={"uri", "manifest"})
    @InfiniteArguments
    @FlexOnly
    public void setCompilerJsNamespacesNamespace(ConfigurationValue cfgval, List<String> args) throws ConfigurationException {
        if (args == null) {
            throw new ConfigurationException.CannotOpen(null, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        if (args.isEmpty()) {
            return;
        }
        if (args.size() < 2) {
            throw new ConfigurationException.NamespaceMissingManifest("namespace", cfgval.getSource(), cfgval.getLine());
        }
        if (args.size() % 2 != 0) {
            throw new ConfigurationException.IncorrectArgumentCount(args.size() + 1, args.size(), cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        if (this.jsmanifestMappings == null) {
            this.jsmanifestMappings = new ArrayList<MXMLNamespaceMapping>();
        }
        for (int i = 0; i < args.size() - 1; i += 2) {
            String uri = args.get(i);
            String manifestFile = args.get(i + 1);
            String path = this.resolvePathStrict(manifestFile, cfgval);
            this.jsmanifestMappings.add(new MXMLNamespaceMapping(uri, path));
        }
    }
}

