/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.standalone;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.StockCodecFactoryUtil;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.IntermediateOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.osgi.DefaultLdapCodecService;
import org.apache.directory.api.ldap.extras.ExtrasCodecFactoryUtil;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.util.Strings;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneLdapApiService
extends DefaultLdapCodecService {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneLdapApiService.class);
    public static final String REQUEST_CONTROLS_LIST = "apacheds.request.controls";
    public static final String RESPONSE_CONTROLS_LIST = "apacheds.response.controls";
    public static final String EXTENDED_OPERATIONS_LIST = "apacheds.extendedOperations";
    public static final String INTERMEDIATE_RESPONSES_LIST = "apacheds.intermediateResponses";
    private static final String OLD_DEFAULT_CONTROLS_LIST = "default.controls";
    private static final String OLD_EXTRA_EXTENDED_OPERATION_LIST = "extra.extendedOperations";

    public StandaloneLdapApiService() throws Exception {
        this(StandaloneLdapApiService.getControlsFromSystemProperties(ControlType.REQUEST), StandaloneLdapApiService.getControlsFromSystemProperties(ControlType.RESPONSE), StandaloneLdapApiService.getExtendedOperationsFromSystemProperties(), StandaloneLdapApiService.getIntermediateResponsesFromSystemProperties());
    }

    public StandaloneLdapApiService(List<String> requestControls, List<String> responseControls, List<String> extendedOperations, List<String> intermediateResponses) throws Exception {
        StockCodecFactoryUtil.loadStockControls((LdapApiService)this);
        ExtrasCodecFactoryUtil.loadExtrasControls((LdapApiService)this);
        ExtrasCodecFactoryUtil.loadExtrasExtendedOperations((LdapApiService)this);
        ExtrasCodecFactoryUtil.loadExtrasIntermediateResponses((LdapApiService)this);
        this.loadControls(requestControls, this.getRequestControlFactories());
        this.loadControls(responseControls, this.getResponseControlFactories());
        this.loadExtendedOperations(extendedOperations);
        this.loadIntermediateResponse(intermediateResponses);
        if (this.getProtocolCodecFactory() == null) {
            try {
                Class<?> clazz = Class.forName("org.apache.directory.api.ldap.codec.protocol.mina.LdapProtocolCodecFactory");
                Constructor<?> constructor = clazz.getConstructor(LdapApiService.class);
                if (constructor != null) {
                    this.setProtocolCodecFactory((ProtocolCodecFactory)constructor.newInstance(new Object[]{this}));
                } else {
                    this.setProtocolCodecFactory((ProtocolCodecFactory)clazz.newInstance());
                }
            }
            catch (Exception cause) {
                throw new RuntimeException(I18n.err((I18n)I18n.ERR_06000_FAILED_TO_LOAD_DEFAULT_CODEC_FACTORY, (Object[])new Object[0]), cause);
            }
        }
    }

    private static List<String> getControlsFromSystemProperties(ControlType type) {
        ArrayList<String> controlsList;
        block2: {
            block3: {
                controlsList = new ArrayList<String>();
                if (type != ControlType.REQUEST) break block2;
                String controlsString = System.getProperty(type.getProperty());
                if (Strings.isEmpty((String)controlsString)) break block3;
                for (String control : controlsString.split(",")) {
                    controlsList.add(control);
                }
                break block2;
            }
            String oldDefaultControlsString = System.getProperty(OLD_DEFAULT_CONTROLS_LIST);
            if (Strings.isEmpty((String)oldDefaultControlsString)) break block2;
            for (String control : oldDefaultControlsString.split(",")) {
                controlsList.add(control);
            }
        }
        return controlsList;
    }

    private static List<String> getExtendedOperationsFromSystemProperties() {
        ArrayList<String> extendedOperationsList;
        block3: {
            block2: {
                extendedOperationsList = new ArrayList<String>();
                String defaultExtendedOperationsList = System.getProperty(EXTENDED_OPERATIONS_LIST);
                if (Strings.isEmpty((String)defaultExtendedOperationsList)) break block2;
                for (String extendedOperation : defaultExtendedOperationsList.split(",")) {
                    extendedOperationsList.add(extendedOperation);
                }
                break block3;
            }
            String oldDefaultExtendedOperationsString = System.getProperty(OLD_EXTRA_EXTENDED_OPERATION_LIST);
            if (Strings.isEmpty((String)oldDefaultExtendedOperationsString)) break block3;
            for (String extendedOperation : oldDefaultExtendedOperationsString.split(",")) {
                extendedOperationsList.add(extendedOperation);
            }
        }
        return extendedOperationsList;
    }

    private static List<String> getIntermediateResponsesFromSystemProperties() {
        ArrayList<String> intermediateResponsesList = new ArrayList<String>();
        String defaultIntermediateResponsesList = System.getProperty(INTERMEDIATE_RESPONSES_LIST);
        if (!Strings.isEmpty((String)defaultIntermediateResponsesList)) {
            for (String intermediateResponse : defaultIntermediateResponsesList.split(",")) {
                intermediateResponsesList.add(intermediateResponse);
            }
        }
        return intermediateResponsesList;
    }

    private void loadControls(List<String> controlsList, Map<String, ControlFactory<? extends Control>> controlFactories) throws Exception {
        if (!controlsList.isEmpty()) {
            for (String controlFQCN : controlsList) {
                this.loadControl(controlFQCN, controlFactories);
            }
        }
    }

    private void loadControl(String controlFQCN, Map<String, ControlFactory<? extends Control>> controlFactories) throws Exception {
        if (controlFactories.containsKey(controlFQCN)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_06003_CONTROL_FACTORY_ALREADY_LOADED, (Object[])new Object[]{controlFQCN}));
            }
            return;
        }
        Class[] types = new Class[]{LdapApiService.class};
        Class<?> clazz = Class.forName(controlFQCN.trim());
        Constructor<?> constructor = clazz.getConstructor(types);
        ControlFactory factory = (ControlFactory)constructor.newInstance(new Object[]{this});
        controlFactories.put(factory.getOid(), (ControlFactory<? extends Control>)factory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06004_REGISTERED_CONTROL_FACTORY, (Object[])new Object[]{factory.getOid()}));
        }
    }

    private void loadExtendedOperations(List<String> extendedOperationsList) throws Exception {
        if (!extendedOperationsList.isEmpty()) {
            for (String extendedOperationFQCN : extendedOperationsList) {
                this.loadExtendedRequest(extendedOperationFQCN);
            }
        }
    }

    private void loadExtendedRequest(String extendedRequestFQCN) throws Exception {
        if (this.getExtendedRequestFactories().containsKey(extendedRequestFQCN)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_06005_EXTENDED_OP_FACTORY_ALREADY_LOADED, (Object[])new Object[]{extendedRequestFQCN}));
            }
            return;
        }
        Class[] types = new Class[]{LdapApiService.class};
        Class<?> clazz = Class.forName(extendedRequestFQCN.trim());
        Constructor<?> constructor = clazz.getConstructor(types);
        ExtendedOperationFactory factory = (ExtendedOperationFactory)constructor.newInstance(new Object[]{this});
        this.getExtendedRequestFactories().put(factory.getOid(), factory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, (Object[])new Object[]{factory.getOid()}));
        }
    }

    private void loadIntermediateResponse(List<String> intermediateResponsesList) throws Exception {
        if (!intermediateResponsesList.isEmpty()) {
            for (String intermediateResponseFQCN : intermediateResponsesList) {
                this.loadIntermediateResponse(intermediateResponseFQCN);
            }
        }
    }

    private void loadIntermediateResponse(String intermediateResponseFQCN) throws Exception {
        if (this.getIntermediateResponseFactories().containsKey(intermediateResponseFQCN)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_06006_INTERMEDIATE_FACTORY_ALREADY_LOADED, (Object[])new Object[]{intermediateResponseFQCN}));
            }
            return;
        }
        Class[] types = new Class[]{};
        Class<?> clazz = Class.forName(intermediateResponseFQCN.trim());
        Constructor<?> constructor = clazz.getConstructor(types);
        IntermediateOperationFactory factory = (IntermediateOperationFactory)constructor.newInstance(new Object[0]);
        this.getIntermediateResponseFactories().put(factory.getOid(), factory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg((I18n)I18n.MSG_06007_REGISTRED_INTERMEDIATE_RESP_FACTORY, (Object[])new Object[]{factory.getOid()}));
        }
    }

    public static enum ControlType {
        REQUEST("apacheds.request.controls"),
        RESPONSE("apacheds.response.controls");

        private String property;

        private ControlType(String property) {
            this.property = property;
        }

        private String getProperty() {
            return this.property;
        }
    }
}

