/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class AttributeClassLoader
extends ClassLoader {
    private Attribute attribute;

    public AttributeClassLoader() {
        super(AttributeClassLoader.class.getClassLoader());
    }

    public void setAttribute(Attribute attribute) throws LdapException {
        if (attribute.isHumanReadable()) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.CONSTRAINT_VIOLATION, I18n.err((I18n)I18n.ERR_16007_BINARY_REQUIRED, (Object[])new Object[0]));
        }
        this.attribute = attribute;
    }

    private static byte[] getBytes(InputStream input) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        int bytesRead = input.read(buf);
        while (bytesRead != -1) {
            result.write(buf, 0, bytesRead);
            bytesRead = input.read(buf);
        }
        result.flush();
        result.close();
        return result.toByteArray();
    }

    private Map<String, Class<?>> loadClasses(byte[] jarBytes) throws IOException {
        HashMap map = new HashMap();
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(jarBytes));){
            JarEntry entry;
            boolean isJar = false;
            while ((entry = jis.getNextJarEntry()) != null) {
                String fileName = entry.getName();
                isJar = true;
                if (!fileName.endsWith(".class")) continue;
                String className = fileName.substring(0, fileName.length() - ".class".length()).replace('/', '.');
                byte[] classBytes = AttributeClassLoader.getBytes(jis);
                Class<?> clazz = this.defineClass(className, classBytes, 0, classBytes.length);
                map.put(className, clazz);
            }
            if (!isJar) {
                Map<String, Class<?>> map2 = null;
                return map2;
            }
        }
        return map;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Value value = this.attribute.get();
        if (value.isHumanReadable()) {
            throw new ClassNotFoundException(I18n.err((I18n)I18n.ERR_16008_AT_ACCESS_FAILURE, (Object[])new Object[0]));
        }
        byte[] classBytes = value.getBytes();
        try {
            Map<String, Class<?>> classes = this.loadClasses(classBytes);
            if (classes == null) {
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            for (Map.Entry<String, Class<?>> entry : classes.entrySet()) {
                if (!entry.getKey().contains(name)) continue;
                return entry.getValue();
            }
        }
        catch (IOException ioe) {
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        return null;
    }
}

