/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.IOException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.LdapConnectionWrapper;

public class PooledLdapConnection
extends LdapConnectionWrapper {
    private LdapConnectionPool pool;

    PooledLdapConnection(LdapConnection delegate) {
        super(delegate);
    }

    PooledLdapConnection(LdapConnection delegate, LdapConnectionPool pool) {
        super(delegate);
        this.pool = pool;
    }

    @Override
    public void close() throws IOException {
        try {
            this.pool.releaseConnection(this.connection);
        }
        catch (LdapException e) {
            throw new IOException("Failed to release connection to pool", e);
        }
    }

    public void setConnectionPool(LdapConnectionPool pool) {
        this.pool = pool;
    }
}

