/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.entry;

import java.text.ParseException;
import java.util.Arrays;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Position;
import org.apache.directory.api.util.Strings;

public final class AttributeUtils {
    private AttributeUtils() {
    }

    public static boolean containsValueCaseIgnore(javax.naming.directory.Attribute attr, Object value) {
        if (attr.contains(value)) {
            return true;
        }
        try {
            if (value instanceof String) {
                String strVal = (String)value;
                NamingEnumeration<?> attrVals = attr.getAll();
                while (attrVals.hasMoreElements()) {
                    Object attrVal = attrVals.nextElement();
                    if (!(attrVal instanceof String) || !strVal.equalsIgnoreCase((String)attrVal)) continue;
                    return true;
                }
            } else {
                byte[] valueBytes = (byte[])value;
                NamingEnumeration<?> attrVals = attr.getAll();
                while (attrVals.hasMoreElements()) {
                    Object attrVal = attrVals.nextElement();
                    if (!(attrVal instanceof byte[]) || !Arrays.equals((byte[])attrVal, valueBytes)) continue;
                    return true;
                }
            }
        }
        catch (NamingException ne) {
            return false;
        }
        return false;
    }

    public static Attributes toCaseInsensitive(Attributes attributes) {
        if (attributes == null) {
            return attributes;
        }
        if (attributes instanceof BasicAttributes) {
            if (attributes.isCaseIgnored()) {
                return attributes;
            }
            BasicAttributes newAttrs = new BasicAttributes(true);
            NamingEnumeration<? extends javax.naming.directory.Attribute> attrs = attributes.getAll();
            if (attrs != null) {
                while (attrs.hasMoreElements()) {
                    newAttrs.put((javax.naming.directory.Attribute)attrs.nextElement());
                }
            }
            return newAttrs;
        }
        return attributes;
    }

    private static void parseOptions(char[] str, Position pos) throws ParseException {
        while (Strings.isCharASCII(str, pos.start, ';')) {
            ++pos.start;
            if (!Chars.isAlphaDigitMinus(str, pos.start)) {
                throw new ParseException(I18n.err(I18n.ERR_13201_EMPTY_OPTION_NOT_ALLOWED, new Object[0]), pos.start);
            }
            ++pos.start;
            while (Chars.isAlphaDigitMinus(str, pos.start)) {
                ++pos.start;
            }
        }
    }

    private static void parseOptions(byte[] bytes, Position pos) throws ParseException {
        while (Strings.isCharASCII(bytes, pos.start, ';')) {
            ++pos.start;
            if (!Chars.isAlphaDigitMinus(bytes, pos.start)) {
                throw new ParseException(I18n.err(I18n.ERR_13201_EMPTY_OPTION_NOT_ALLOWED, new Object[0]), pos.start);
            }
            ++pos.start;
            while (Chars.isAlphaDigitMinus(bytes, pos.start)) {
                ++pos.start;
            }
        }
    }

    private static boolean parseNumber(char[] filter, Position pos) {
        char c = Strings.charAt(filter, pos.start);
        switch (c) {
            case '0': {
                ++pos.start;
                return true;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                ++pos.start;
                break;
            }
            default: {
                return false;
            }
        }
        while (Chars.isDigit(filter, pos.start)) {
            ++pos.start;
        }
        return true;
    }

    private static boolean parseNumber(byte[] bytes, Position pos) {
        byte b = Strings.byteAt(bytes, pos.start);
        switch (b) {
            case 48: {
                ++pos.start;
                return true;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                ++pos.start;
                break;
            }
            default: {
                return false;
            }
        }
        while (Chars.isDigit(bytes, pos.start)) {
            ++pos.start;
        }
        return true;
    }

    private static void parseOID(char[] str, Position pos) throws ParseException {
        AttributeUtils.parseNumber(str, pos);
        if (!Strings.isCharASCII(str, pos.start, '.')) {
            throw new ParseException(I18n.err(I18n.ERR_13221_INVALID_OID_MISSING_DOT, new Object[0]), pos.start);
        }
        ++pos.start;
        if (!AttributeUtils.parseNumber(str, pos)) {
            throw new ParseException(I18n.err(I18n.ERR_13202_INVALID_OID_MISSING_NUMBER, new Object[0]), pos.start);
        }
        while (Strings.isCharASCII(str, pos.start, '.')) {
            ++pos.start;
            if (AttributeUtils.parseNumber(str, pos)) continue;
            throw new ParseException(I18n.err(I18n.ERR_13202_INVALID_OID_MISSING_NUMBER, new Object[0]), pos.start);
        }
    }

    private static void parseOID(byte[] bytes, Position pos) throws ParseException {
        AttributeUtils.parseNumber(bytes, pos);
        if (!Strings.isCharASCII(bytes, pos.start, '.')) {
            throw new ParseException(I18n.err(I18n.ERR_13221_INVALID_OID_MISSING_DOT, new Object[0]), pos.start);
        }
        ++pos.start;
        if (!AttributeUtils.parseNumber(bytes, pos)) {
            throw new ParseException(I18n.err(I18n.ERR_13202_INVALID_OID_MISSING_NUMBER, new Object[0]), pos.start);
        }
        while (Strings.isCharASCII(bytes, pos.start, '.')) {
            ++pos.start;
            if (AttributeUtils.parseNumber(bytes, pos)) continue;
            throw new ParseException(I18n.err(I18n.ERR_13202_INVALID_OID_MISSING_NUMBER, new Object[0]), pos.start);
        }
    }

    public static String parseAttribute(char[] str, Position pos, boolean withOption, boolean relaxed) throws ParseException {
        char c = Strings.charAt(str, pos.start);
        if (c == '\u0000') {
            throw new ParseException(I18n.err(I18n.ERR_13222_EMPTY_ATTRIBUTE, new Object[0]), pos.start);
        }
        int start = pos.start++;
        if (Chars.isAlpha(c)) {
            while (Chars.isAlphaDigitMinus(str, pos.start) || relaxed && Chars.isCharASCII(str, pos.start, '_')) {
                ++pos.start;
            }
            if (withOption) {
                AttributeUtils.parseOptions(str, pos);
            }
            return new String(str, start, pos.start - start);
        }
        if (Chars.isDigit(c)) {
            ++pos.start;
            AttributeUtils.parseOID(str, pos);
            if (withOption) {
                AttributeUtils.parseOptions(str, pos);
            }
            return new String(str, start, pos.start - start);
        }
        throw new ParseException(I18n.err(I18n.ERR_13223_BAD_CHAR_IN_ATTRIBUTE, new Object[0]), pos.start);
    }

    public static String parseAttribute(byte[] bytes, Position pos, boolean withOption, boolean relaxed) throws ParseException {
        byte b = Strings.byteAt(bytes, pos.start);
        if (b == 0) {
            throw new ParseException(I18n.err(I18n.ERR_13222_EMPTY_ATTRIBUTE, new Object[0]), pos.start);
        }
        int start = pos.start;
        if (Chars.isAlpha(b)) {
            while (Chars.isAlphaDigitMinus(bytes, pos.start) || relaxed && Strings.isCharASCII(bytes, pos.start, '_')) {
                ++pos.start;
            }
            if (withOption) {
                AttributeUtils.parseOptions(bytes, pos);
            }
            return Strings.utf8ToString(bytes, start, pos.start - start);
        }
        if (Chars.isDigit(b)) {
            AttributeUtils.parseOID(bytes, pos);
            if (withOption) {
                AttributeUtils.parseOptions(bytes, pos);
            }
            return Strings.utf8ToString(bytes, start, pos.start - start);
        }
        throw new ParseException(I18n.err(I18n.ERR_13223_BAD_CHAR_IN_ATTRIBUTE, new Object[0]), pos.start);
    }

    public static void applyModification(Entry entry, Modification modification) throws LdapException {
        Attribute modAttr = modification.getAttribute();
        String modificationId = modAttr.getUpId();
        switch (modification.getOperation()) {
            case ADD_ATTRIBUTE: {
                Attribute modifiedAttr = entry.get(modificationId);
                if (modifiedAttr == null) {
                    entry.put(modAttr);
                    break;
                }
                for (Value value : modAttr) {
                    modifiedAttr.add(value);
                }
                break;
            }
            case REMOVE_ATTRIBUTE: {
                if (modAttr.get() == null) {
                    entry.removeAttributes(modificationId);
                    break;
                }
                Attribute modifiedAttr = entry.get(modificationId);
                if (modifiedAttr == null) break;
                for (Value value : modAttr) {
                    modifiedAttr.remove(value);
                }
                if (modifiedAttr.size() != 0) break;
                entry.removeAttributes(modifiedAttr.getUpId());
                break;
            }
            case REPLACE_ATTRIBUTE: {
                if (modAttr.get() == null) {
                    entry.removeAttributes(modificationId);
                    break;
                }
                entry.put(modAttr);
                break;
            }
        }
    }

    public static Entry toEntry(Attributes attributes, Dn dn) throws LdapException {
        if (attributes instanceof BasicAttributes) {
            try {
                DefaultEntry entry = new DefaultEntry(dn);
                NamingEnumeration<? extends javax.naming.directory.Attribute> attrs = attributes.getAll();
                while (attrs.hasMoreElements()) {
                    javax.naming.directory.Attribute attr = (javax.naming.directory.Attribute)attrs.nextElement();
                    Attribute entryAttribute = AttributeUtils.toApiAttribute(attr);
                    if (entryAttribute == null) continue;
                    entry.put(entryAttribute);
                }
                return entry;
            }
            catch (LdapException ne) {
                throw new LdapInvalidAttributeTypeException(ne.getMessage(), ne);
            }
        }
        return null;
    }

    public static Attributes toAttributes(Entry entry) {
        if (entry != null) {
            BasicAttributes attributes = new BasicAttributes(true);
            for (Attribute entryAttribute : entry) {
                attributes.put(AttributeUtils.toJndiAttribute(entryAttribute));
            }
            return attributes;
        }
        return null;
    }

    public static javax.naming.directory.Attribute toJndiAttribute(Attribute attribute) {
        if (attribute != null) {
            BasicAttribute jndiAttribute = new BasicAttribute(attribute.getUpId());
            for (Value value : attribute) {
                if (value.isHumanReadable()) {
                    jndiAttribute.add(value.getString());
                    continue;
                }
                jndiAttribute.add(value.getBytes());
            }
            return jndiAttribute;
        }
        return null;
    }

    public static Attribute toApiAttribute(javax.naming.directory.Attribute jndiAttribute) throws LdapInvalidAttributeValueException {
        if (jndiAttribute == null) {
            return null;
        }
        try {
            DefaultAttribute attribute = new DefaultAttribute(jndiAttribute.getID());
            NamingEnumeration<?> values = jndiAttribute.getAll();
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                if (value instanceof String) {
                    attribute.add((String)value);
                    continue;
                }
                if (value instanceof byte[]) {
                    attribute.add(new byte[][]{(byte[])value});
                    continue;
                }
                attribute.add(new String[]{null});
            }
            return attribute;
        }
        catch (NamingException ne) {
            return null;
        }
    }
}

