/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad;

import java.util.Arrays;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncRequest;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.util.Strings;

public class AdDirSyncRequestImpl
extends AbstractControl
implements AdDirSyncRequest {
    private int parentsFirst;
    private int maxAttributeCount = 0;
    private byte[] cookie;

    public AdDirSyncRequestImpl() {
        super("1.2.840.113556.1.4.841", Boolean.TRUE);
    }

    @Override
    public int getParentsFirst() {
        return this.parentsFirst;
    }

    @Override
    public void setParentsFirst(int parentsFirst) {
        this.parentsFirst = parentsFirst;
    }

    @Override
    public int getMaxAttributeCount() {
        return this.maxAttributeCount;
    }

    @Override
    public void setMaxAttributeCount(int maxAttributeCount) {
        this.maxAttributeCount = maxAttributeCount;
    }

    @Override
    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public void setCookie(byte[] cookie) {
        if (cookie != null) {
            this.cookie = new byte[cookie.length];
            System.arraycopy(cookie, 0, this.cookie, 0, cookie.length);
        } else {
            this.cookie = Strings.EMPTY_BYTES;
        }
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = h * 17 + this.parentsFirst;
        h = h * 17 + this.maxAttributeCount;
        if (this.cookie != null) {
            for (byte b : this.cookie) {
                h = h * 17 + b;
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AdDirSyncRequest)) {
            return false;
        }
        AdDirSyncRequest otherControl = (AdDirSyncRequest)other;
        return super.equals(other) && this.maxAttributeCount == otherControl.getMaxAttributeCount() && this.parentsFirst == otherControl.getParentsFirst() && Arrays.equals(this.cookie, otherControl.getCookie()) && this.isCritical() == otherControl.isCritical();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    DirSync control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        parentsFirst : ").append(this.parentsFirst).append("\n");
        sb.append("        maxAttributeCount : '").append(this.maxAttributeCount).append("'\n");
        sb.append("        cookie            : '").append(Strings.dumpBytes(this.getCookie())).append("'\n");
        return sb.toString();
    }
}

