/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.search.SubstringFilter;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSubstringFilterType
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSubstringFilterType.class);

    public StoreSubstringFilterType() {
        super("Store Substring filter type");
    }

    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        SubstringFilter substringFilter = (SubstringFilter)container.getTerminalFilter();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05153_NULL_ATTRIBUTE_DESCRIPTION, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        String type = Strings.utf8ToString((byte[])tlv.getValue().getData());
        substringFilter.setType(type);
        container.setTerminalFilter(substringFilter);
    }
}

