/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.search.SubstringFilter;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSubstringsFilter
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitSubstringsFilter.class);

    public InitSubstringsFilter() {
        super("Initialize Substrings filter");
    }

    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        int expectedLength = tlv.getLength();
        if (expectedLength == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05138_EMPTY_SUBSTRING_FILTER_PDU, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        SubstringFilter substringFilter = new SubstringFilter(container.getCurrentTLV().getId());
        container.addCurrentFilter(substringFilter);
        container.setTerminalFilter(substringFilter);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05152_INITIALIZE_SUBSTRING_FILTER, (Object[])new Object[0]));
        }
    }
}

