/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.modifydn;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.DnFactory;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModifyDnRequestNewSuperior
extends GrammarAction<LdapMessageContainer<ModifyDnRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyDnRequestNewSuperior.class);

    public StoreModifyDnRequestNewSuperior() {
        super("Store new superior");
    }

    public void action(LdapMessageContainer<ModifyDnRequest> container) throws DecoderException {
        ModifyDnRequest modifyDnRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            if (modifyDnRequest.getDeleteOldRdn()) {
                throw new DecoderException(I18n.err((I18n)I18n.ERR_05128_NULL_SUPERIOR, (Object[])new Object[0]));
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn(I18n.msg((I18n)I18n.MSG_05139_NULL_NEW_SUPERIOR, (Object[])new Object[0]));
            }
            modifyDnRequest.setNewSuperior(Dn.EMPTY_DN);
        } else {
            byte[] dnBytes = tlv.getValue().getData();
            String dnStr = Strings.utf8ToString((byte[])dnBytes);
            try {
                DnFactory dnFactory = container.getDnFactory();
                Dn newSuperior = dnFactory == null ? new Dn(new String[]{dnStr}) : dnFactory.create(dnStr);
                modifyDnRequest.setNewSuperior(newSuperior);
            }
            catch (LdapInvalidDnException ine) {
                String msg = I18n.err((I18n)I18n.ERR_05129_INVALID_NEW_SUPERIOR, (Object[])new Object[]{dnStr, Strings.dumpBytes((byte[])dnBytes)});
                LOG.error(I18n.err((I18n)I18n.ERR_05114_ERROR_MESSAGE, (Object[])new Object[]{msg, ine.getMessage()}));
                ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
                throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), ine);
            }
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05140_NEW_SUPERIOR_DN, (Object[])new Object[]{modifyDnRequest.getNewSuperior()}));
        }
    }
}

