/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import java.io.StringReader;
import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.AntlrDnLexer;
import org.apache.directory.api.ldap.model.name.AntlrDnParser;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

class ComplexDnParser {
    ComplexDnParser() {
    }

    String parseDn(SchemaManager schemaManager, String name, List<Rdn> rdns) throws LdapInvalidDnException {
        AntlrDnParser dnParser = new AntlrDnParser(new AntlrDnLexer(new StringReader(name)));
        try {
            return dnParser.relativeDistinguishedNames(schemaManager, rdns);
        }
        catch (Exception e) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, e.getMessage(), e);
        }
    }

    void parseRdn(SchemaManager schemaManager, String name, Rdn rdn) throws LdapInvalidDnException {
        AntlrDnParser dnParser = new AntlrDnParser(new AntlrDnLexer(new StringReader(name)));
        try {
            dnParser.relativeDistinguishedName(schemaManager, rdn);
        }
        catch (Exception e) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, e.getMessage(), e);
        }
    }
}

