/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import org.apache.directory.mavibot.btree.DeleteResult;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.KeyCursor;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;

interface Page<K, V> {
    public int getNbElems();

    public InsertResult<K, V> insert(K var1, V var2, long var3) throws IOException;

    public DeleteResult<K, V> delete(K var1, V var2, long var3) throws IOException;

    public V get(K var1) throws KeyNotFoundException, IOException;

    public ValueCursor<V> getValues(K var1) throws KeyNotFoundException, IOException, IllegalArgumentException;

    public boolean contains(K var1, V var2) throws IOException;

    public TupleCursor<K, V> browse(K var1, ReadTransaction<K, V> var2, ParentPos<K, V>[] var3, int var4) throws IOException;

    public TupleCursor<K, V> browse(ReadTransaction<K, V> var1, ParentPos<K, V>[] var2, int var3) throws EndOfFileExceededException, IOException;

    public KeyCursor<K> browseKeys(ReadTransaction<K, K> var1, ParentPos<K, K>[] var2, int var3) throws EndOfFileExceededException, IOException;

    public long getRevision();

    public K getKey(int var1);

    public K getLeftMostKey();

    public K getRightMostKey();

    public Tuple<K, V> findLeftMost() throws IOException;

    public Tuple<K, V> findRightMost() throws EndOfFileExceededException, IOException;

    public String dumpPage(String var1);

    public int findPos(K var1);

    public boolean hasKey(K var1) throws IOException;

    public boolean isLeaf();

    public boolean isNode();
}

