/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.partialbean.impl;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.Annotateds;
import org.apache.deltaspike.core.util.AnnotationUtils;
import org.apache.deltaspike.core.util.BeanConfiguratorUtils;
import org.apache.deltaspike.core.util.BeanUtils;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ReflectionUtils;
import org.apache.deltaspike.partialbean.api.PartialBeanBinding;
import org.apache.deltaspike.partialbean.impl.PartialBeanDescriptor;
import org.apache.deltaspike.partialbean.impl.PartialBeanProxyFactory;
import org.apache.deltaspike.proxy.api.DeltaSpikeProxyBeanConfigurator;
import org.apache.deltaspike.proxy.api.DeltaSpikeProxyFactory;

public class PartialBeanBindingExtension
implements Extension,
Deactivatable {
    private final Map<Class<? extends Annotation>, PartialBeanDescriptor> descriptors = new HashMap<Class<? extends Annotation>, PartialBeanDescriptor>();
    private Boolean isActivated = true;
    private IllegalStateException definitionError;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    public <X> void findInvocationHandlerBindings(@Observes ProcessAnnotatedType<X> pat) {
        if (!this.isActivated.booleanValue() || this.definitionError != null) {
            return;
        }
        Class beanClass = pat.getAnnotatedType().getJavaClass();
        Class<Annotation> bindingClass = this.extractBindingClass(pat);
        if (bindingClass == null) {
            return;
        }
        if (beanClass.isInterface() || Modifier.isAbstract(beanClass.getModifiers())) {
            pat.veto();
            PartialBeanDescriptor descriptor = this.descriptors.get(bindingClass);
            if (descriptor == null) {
                descriptor = new PartialBeanDescriptor(bindingClass, null, beanClass);
                this.descriptors.put(bindingClass, descriptor);
            } else if (!descriptor.getClasses().contains(beanClass)) {
                descriptor.getClasses().add(beanClass);
            }
        } else if (InvocationHandler.class.isAssignableFrom(beanClass)) {
            PartialBeanDescriptor descriptor = this.descriptors.get(bindingClass);
            if (descriptor == null) {
                descriptor = new PartialBeanDescriptor(bindingClass, beanClass);
                this.descriptors.put(bindingClass, descriptor);
            } else if (descriptor.getHandler() == null) {
                descriptor.setHandler(beanClass);
            } else if (!descriptor.getHandler().equals(beanClass)) {
                this.definitionError = new IllegalStateException("Multiple handlers found for " + bindingClass.getName() + " (" + descriptor.getHandler().getName() + " and " + beanClass.getName() + ")");
            }
        } else {
            this.definitionError = new IllegalStateException(beanClass.getName() + " is annotated with @" + bindingClass.getName() + " and therefore has to be an abstract class, an interface or an implementation of " + InvocationHandler.class.getName());
        }
    }

    public <X> void createBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        if (this.definitionError != null) {
            afterBeanDiscovery.addDefinitionError((Throwable)this.definitionError);
            return;
        }
        for (Map.Entry<Class<? extends Annotation>, PartialBeanDescriptor> entry : this.descriptors.entrySet()) {
            PartialBeanDescriptor descriptor = entry.getValue();
            if (descriptor.getClasses() == null) continue;
            for (Class<?> partialBeanClass : descriptor.getClasses()) {
                boolean added = this.createPartialBean(partialBeanClass, descriptor, afterBeanDiscovery, beanManager);
                if (!added) continue;
                this.createPartialProducersDefinedIn(afterBeanDiscovery, beanManager, partialBeanClass);
            }
        }
        this.descriptors.clear();
    }

    protected <T> boolean createPartialBean(Class<T> beanClass, PartialBeanDescriptor descriptor, AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (descriptor.getHandler() == null) {
            afterBeanDiscovery.addDefinitionError((Throwable)new IllegalStateException("A class which implements " + InvocationHandler.class.getName() + " and is annotated with @" + descriptor.getBinding().getName() + " is needed as a handler for " + beanClass.getName() + ". See the documentation about @" + PartialBeanBinding.class.getName() + "."));
            return false;
        }
        AnnotatedType annotatedType = beanManager.createAnnotatedType(beanClass);
        BeanConfigurator beanConfigurator = afterBeanDiscovery.addBean();
        BeanConfiguratorUtils.read((BeanManager)beanManager, (BeanConfigurator)beanConfigurator, (AnnotatedType)annotatedType).beanClass(beanClass);
        beanConfigurator.id(PartialBeanBinding.class.getName() + ":" + Annotateds.createTypeId((AnnotatedType)annotatedType));
        new DeltaSpikeProxyBeanConfigurator(beanClass, descriptor.getHandler(), (DeltaSpikeProxyFactory)PartialBeanProxyFactory.getInstance(), beanManager, beanConfigurator).delegateCreateWith().delegateDestroyWith();
        return true;
    }

    protected <X> Class<? extends Annotation> extractBindingClass(ProcessAnnotatedType<X> pat) {
        for (Annotation annotation : pat.getAnnotatedType().getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(PartialBeanBinding.class)) continue;
            return annotation.annotationType();
        }
        return null;
    }

    private void createPartialProducersDefinedIn(AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager, Class currentClass) {
        while (currentClass != null && !Object.class.getName().equals(currentClass.getName())) {
            for (Class<?> clazz : currentClass.getInterfaces()) {
                if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.") || clazz.getName().startsWith("jakarta.")) continue;
                this.createPartialProducersDefinedIn(afterBeanDiscovery, beanManager, clazz);
            }
            for (GenericDeclaration genericDeclaration : currentClass.getDeclaredMethods()) {
                if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(Produces.class)) continue;
                if (((Method)genericDeclaration).getParameterTypes().length > 0) {
                    afterBeanDiscovery.addDefinitionError((Throwable)new IllegalStateException("Producer-methods in partial-beans currently don't support injection-points. Please remove the parameters from " + ((Method)genericDeclaration).toString() + " in " + currentClass.getName()));
                }
                Class<? extends Annotation> scopeClass = this.extractScope(((Method)genericDeclaration).getDeclaredAnnotations(), beanManager);
                Class<?> producerResultType = ((Method)genericDeclaration).getReturnType();
                Set<Annotation> qualifiers = this.extractQualifiers(((Method)genericDeclaration).getDeclaredAnnotations(), beanManager);
                Class partialBeanClass = currentClass;
                afterBeanDiscovery.addBean().beanClass(producerResultType).types(new Type[]{Object.class, producerResultType}).qualifiers(qualifiers).scope(scopeClass).id(this.createPartialProducerId(currentClass, (Method)genericDeclaration, qualifiers)).produceWith(arg_0 -> PartialBeanBindingExtension.lambda$createPartialProducersDefinedIn$0(partialBeanClass, (Method)genericDeclaration, arg_0));
            }
            currentClass = currentClass.getSuperclass();
        }
    }

    private Set<Annotation> extractQualifiers(Annotation[] annotations, BeanManager beanManager) {
        Set result = BeanUtils.getQualifiers((BeanManager)beanManager, (Annotation[][])new Annotation[][]{annotations});
        if (result.isEmpty()) {
            result.add(Default.Literal.INSTANCE);
        }
        return result;
    }

    private Class<? extends Annotation> extractScope(Annotation[] annotations, BeanManager beanManager) {
        for (Annotation annotation : annotations) {
            if (!beanManager.isScope(annotation.annotationType())) continue;
            return annotation.annotationType();
        }
        return Dependent.class;
    }

    private String createPartialProducerId(Class currentClass, Method currentMethod, Set<Annotation> qualifiers) {
        int qualifierHashCode = 0;
        for (Annotation qualifier : qualifiers) {
            qualifierHashCode += AnnotationUtils.getQualifierHashCode((Annotation)qualifier);
        }
        return "PartialProducer#" + currentClass.getName() + "#" + currentMethod.getName() + "#" + qualifierHashCode;
    }

    private static /* synthetic */ Object lambda$createPartialProducersDefinedIn$0(Class partialBeanClass, Method currentMethod, Instance e) {
        Object instance = BeanProvider.getContextualReference((Class)partialBeanClass, (Annotation[])new Annotation[0]);
        return ReflectionUtils.invokeMethod((Object)instance, (Method)currentMethod, Object.class, (boolean)false, (Object[])new Object[0]);
    }
}

