/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.admin.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jcs.admin.JCSAdminBean;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.VelocityViewServlet;

public class JCSAdminServlet
extends VelocityViewServlet {
    private static final long serialVersionUID = -5519844149238645275L;
    private static final String DEFAULT_TEMPLATE_NAME = "/org/apache/jcs/admin/servlet/JCSAdminServletDefault.vm";
    private static final String REGION_DETAIL_TEMPLATE_NAME = "/org/apache/jcs/admin/servlet/JCSAdminServletRegionDetail.vm";
    private static final String CACHE_NAME_PARAM = "cacheName";
    private static final String ACTION_PARAM = "action";
    private static final String KEY_PARAM = "key";
    private static final String SILENT_PARAM = "silent";
    private static final String CLEAR_ALL_REGIONS_ACTION = "clearAllRegions";
    private static final String CLEAR_REGION_ACTION = "clearRegion";
    private static final String REMOVE_ACTION = "remove";
    private static final String DETAIL_ACTION = "detail";

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context context) {
        JCSAdminBean admin = new JCSAdminBean();
        String templateName = DEFAULT_TEMPLATE_NAME;
        String cacheName = request.getParameter(CACHE_NAME_PARAM);
        String action = request.getParameter(ACTION_PARAM);
        try {
            if (action != null) {
                if (action.equals(CLEAR_ALL_REGIONS_ACTION)) {
                    admin.clearAllRegions();
                } else if (action.equals(CLEAR_REGION_ACTION)) {
                    if (cacheName != null) {
                        admin.clearRegion(cacheName);
                    }
                } else if (action.equals(REMOVE_ACTION)) {
                    String[] keys = request.getParameterValues(KEY_PARAM);
                    for (int i = 0; i < keys.length; ++i) {
                        admin.removeItem(cacheName, keys[i]);
                    }
                    templateName = REGION_DETAIL_TEMPLATE_NAME;
                } else if (action.equals(DETAIL_ACTION)) {
                    templateName = REGION_DETAIL_TEMPLATE_NAME;
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((Object)"Could not execute action.", (Throwable)e);
            return null;
        }
        if (request.getParameter(SILENT_PARAM) != null) {
            return null;
        }
        try {
            if (templateName == REGION_DETAIL_TEMPLATE_NAME) {
                context.put(CACHE_NAME_PARAM, (Object)cacheName);
                context.put("elementInfoRecords", (Object)admin.buildElementInfo(cacheName));
            } else if (templateName == DEFAULT_TEMPLATE_NAME) {
                context.put("cacheInfoRecords", (Object)admin.buildCacheInfo());
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)"Could not populate context.", (Throwable)e);
        }
        return this.getTemplate(templateName);
    }
}

