/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.manager;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.torque.TorqueException;
import org.apache.torque.manager.MethodCacheKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodResultCache {
    private GroupCacheAccess jcsCache;
    private Map<String, Object> groups;
    private static Log log = LogFactory.getLog(MethodResultCache.class);

    public MethodResultCache(GroupCacheAccess cache) {
        this.jcsCache = cache;
        this.groups = new HashMap<String, Object>();
    }

    protected MethodResultCache() {
    }

    public void clear() {
        if (this.jcsCache != null) {
            try {
                this.jcsCache.clear();
                this.groups.clear();
            }
            catch (CacheException ce) {
                log.error((Object)new TorqueException("Could not clear cache due to internal JCS error.", ce));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getImpl(MethodCacheKey key) {
        Object result = null;
        if (this.jcsCache != null) {
            MethodResultCache methodResultCache = this;
            synchronized (methodResultCache) {
                result = this.jcsCache.getFromGroup((Object)key, key.getGroupKey());
            }
        }
        if (result != null && log.isDebugEnabled()) {
            log.debug((Object)("MethodResultCache saved expensive operation: " + key));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object putImpl(MethodCacheKey key, Object value) throws TorqueException {
        String group = key.getGroupKey();
        if (!this.groups.containsKey(group)) {
            this.groups.put(group, null);
        }
        Object old = null;
        if (this.jcsCache != null) {
            try {
                MethodResultCache methodResultCache = this;
                synchronized (methodResultCache) {
                    old = this.jcsCache.getFromGroup((Object)key, group);
                    this.jcsCache.putInGroup((Object)key, group, value);
                }
            }
            catch (CacheException ce) {
                throw new TorqueException("Could not cache due to internal JCS error", ce);
            }
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeImpl(MethodCacheKey key) {
        Object old = null;
        if (this.jcsCache != null) {
            MethodResultCache methodResultCache = this;
            synchronized (methodResultCache) {
                old = this.jcsCache.getFromGroup((Object)key, key.getGroupKey());
                this.jcsCache.remove((Object)key, key.getGroupKey());
            }
        }
        return old;
    }

    public <T> T get(Serializable instanceOrClass, String method, Serializable ... arg) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = new MethodCacheKey(instanceOrClass, method, arg);
                result = this.getImpl(key);
            }
            catch (Exception e) {
                log.error((Object)"Problem getting object from cache", (Throwable)e);
            }
        }
        return (T)result;
    }

    public <T> void put(T value, Serializable instanceOrClass, String method, Serializable ... arg) {
        try {
            MethodCacheKey key = new MethodCacheKey(instanceOrClass, method, arg);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"Problem putting object into cache", (Throwable)e);
        }
    }

    public void removeAll(Serializable instanceOrClass, String method) {
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = new MethodCacheKey(instanceOrClass, method, new Serializable[0]);
                String groupName = key.getGroupKey();
                this.jcsCache.invalidateGroup(groupName);
                this.groups.remove(groupName);
            }
            catch (Exception e) {
                log.error((Object)"Problem removing all", (Throwable)e);
            }
        }
    }

    public <T> T remove(Serializable instanceOrClass, String method, Serializable ... arg) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = new MethodCacheKey(instanceOrClass, method, arg);
                result = this.removeImpl(key);
            }
            catch (Exception e) {
                log.error((Object)"Problem removing object from cache", (Throwable)e);
            }
        }
        return (T)result;
    }
}

