/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Vector;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.AggregatorInfoList;
import org.apache.derby.impl.sql.execute.GenericAggregator;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.error.SQLWarningFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class GenericAggregateResultSet
extends NoPutResultSetImpl {
    protected GenericAggregator[] aggregates;
    protected AggregatorInfoList aggInfoList;
    public NoPutResultSet source;
    protected NoPutResultSet originalSource;
    private final ExecIndexRow rowTemplate;

    GenericAggregateResultSet(NoPutResultSet s, int aggregateItem, Activation a, int ra, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        this.originalSource = s;
        ExecPreparedStatement ps = a.getPreparedStatement();
        ExecutionFactory ef = a.getExecutionFactory();
        this.rowTemplate = ef.getIndexableRow(((ExecRowBuilder)ps.getSavedObject(ra)).build(ef));
        this.aggInfoList = (AggregatorInfoList)ps.getSavedObject(aggregateItem);
        this.aggregates = this.getSortAggregators(this.aggInfoList, false, a.getLanguageConnectionContext(), s);
    }

    ExecIndexRow getRowTemplate() {
        return this.rowTemplate;
    }

    protected final GenericAggregator[] getSortAggregators(AggregatorInfoList list, boolean eliminateDistincts, LanguageConnectionContext lcc, NoPutResultSet inputResultSet) throws StandardException {
        Vector<GenericAggregator> tmpAggregators = new Vector<GenericAggregator>();
        ClassFactory cf = lcc.getLanguageConnectionFactory().getClassFactory();
        for (AggregatorInfo aggInfo : list) {
            if (eliminateDistincts && aggInfo.isDistinct()) continue;
            tmpAggregators.addElement(new GenericAggregator(aggInfo, cf));
        }
        Object[] aggregators = new GenericAggregator[tmpAggregators.size()];
        tmpAggregators.copyInto(aggregators);
        return aggregators;
    }

    protected final ExecIndexRow finishAggregation(ExecIndexRow row) throws StandardException {
        int size = this.aggregates.length;
        if (row == null) {
            row = this.getRowTemplate();
        }
        this.setCurrentRow(row);
        boolean eliminatedNulls = false;
        for (int i = 0; i < size; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            if (!currAggregate.finish(row)) continue;
            eliminatedNulls = true;
        }
        if (eliminatedNulls) {
            this.addWarning(SQLWarningFactory.newSQLWarning("01003", new Object[0]));
        }
        return row;
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        super.finish();
    }

    @Override
    public Element toXML(Element parentNode, String tag) throws Exception {
        Element result = super.toXML(parentNode, tag);
        NodeList children = result.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(0);
            if (!"originalSource".equals(child.getNodeName())) continue;
            result.removeChild(child);
        }
        return result;
    }
}

