/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class PrivilegedFileOpsForTests {
    public static long length(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return file.length();
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return file.getAbsolutePath();
    }

    public static URI toURI(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return file.toURI();
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        return File.createTempFile(prefix, suffix, directory);
    }

    public static FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return new FileInputStream(file);
    }

    public static boolean exists(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return file.exists();
    }

    public static boolean delete(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return file.delete();
    }

    public static boolean mkdir(File dir) {
        return dir.mkdir();
    }

    public static boolean setReadable(File file, boolean readable, boolean ownerOnly) {
        return file.setReadable(readable, ownerOnly);
    }

    public static boolean setReadOnly(File file) {
        return file.setReadOnly();
    }

    public static FileReader getFileReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return new FileReader(file);
    }

    public static FileWriter getFileWriter(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return new FileWriter(file);
    }

    public static File[] listFiles(File dir) {
        return dir.listFiles();
    }

    public static void copy(File source, File target) throws IOException {
        PrivilegedFileOpsForTests.recursiveCopy(source, target);
    }

    private static void recursiveCopy(File source, File target) throws IOException {
        byte[] buf = new byte[32768];
        if (source.isFile()) {
            PrivilegedFileOpsForTests.copySingleFile(source, target, buf);
            return;
        }
        String[] list = source.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(source, list[i]);
                File targetEntry = new File(target, list[i]);
                if (entry.isDirectory()) {
                    PrivilegedFileOpsForTests.copy(entry, targetEntry);
                    continue;
                }
                PrivilegedFileOpsForTests.copySingleFile(entry, targetEntry, buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySingleFile(File source, File target, byte[] buf) throws IOException {
        File targetParent;
        if (buf == null) {
            buf = new byte[32768];
        }
        if ((targetParent = target.getParentFile()) != null && !targetParent.exists()) {
            target.getParentFile().mkdirs();
        }
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        try {
            int read;
            while ((read = ((InputStream)in).read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, read);
            }
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static FileOutputStream getFileOutputStream(File file) throws FileNotFoundException {
        return PrivilegedFileOpsForTests.getFileOutputStream(file, false);
    }

    public static FileOutputStream getFileOutputStream(File file, boolean append) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return new FileOutputStream(file, append);
    }

    public static File[] persistentRecursiveDelete(File dir) throws FileNotFoundException {
        if (!PrivilegedFileOpsForTests.exists(dir)) {
            throw new FileNotFoundException(PrivilegedFileOpsForTests.getAbsolutePath(dir));
        }
        ArrayList<File> notDeleted = new ArrayList<File>();
        PrivilegedFileOpsForTests.deleteRecursively(dir, notDeleted);
        return notDeleted.toArray(new File[notDeleted.size()]);
    }

    private static boolean deleteRecursively(File dir, List<File> failedDeletes) {
        File[] files;
        boolean allDeleted = true;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) {
                    allDeleted &= PrivilegedFileOpsForTests.deleteRecursively(f, failedDeletes);
                    continue;
                }
                allDeleted &= PrivilegedFileOpsForTests.internalDelete(f, failedDeletes);
            }
        }
        return allDeleted &= PrivilegedFileOpsForTests.internalDelete(dir, failedDeletes);
    }

    private static boolean internalDelete(File f, List<File> failedDeletes) {
        boolean deleted = f.delete();
        if (!deleted) {
            failedDeletes.add(f);
        }
        return deleted;
    }

    public static String getFileInfo(File f) {
        if (!f.exists()) {
            return "(non-existant)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(isDir=").append(f.isDirectory()).append(", canRead=").append(f.canRead()).append(", canWrite=").append(f.canWrite()).append(", size=").append(f.length()).append(')');
        return sb.toString();
    }
}

