/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.shared.common.sanity.SanityManager;

class BTreePostCommit
implements Serviceable {
    private AccessFactory access_factory = null;
    private long page_number = -1L;
    protected BTree btree = null;

    BTreePostCommit(AccessFactory access_factory, BTree btree, long input_page_number) {
        this.access_factory = access_factory;
        this.btree = btree;
        this.page_number = input_page_number;
    }

    @Override
    public boolean serviceASAP() {
        return true;
    }

    @Override
    public boolean serviceImmediately() {
        return false;
    }

    private final void doShrink(OpenBTree open_btree, DataValueDescriptor[] shrink_row) throws StandardException {
        ControlRow root = null;
        root = ControlRow.get(open_btree, 1L);
        root.shrinkFor(open_btree, shrink_row);
        root = null;
    }

    private final OpenBTree openIndex(TransactionManager internal_xact, int lock_level, int lock_mode) throws StandardException {
        OpenBTree open_btree = new OpenBTree();
        ConglomerateController base_cc = this.btree.lockTable(internal_xact, 132, lock_level, 4);
        open_btree.init(null, internal_xact, null, internal_xact.getRawStoreXact(), false, 132, lock_level, this.btree.getBtreeLockingPolicy(internal_xact.getRawStoreXact(), lock_level, lock_mode, 4, base_cc, open_btree), this.btree, null, null);
        return open_btree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performWork(ContextManager contextMgr) throws StandardException {
        boolean requeue_work = false;
        TransactionManager tc = (TransactionManager)this.access_factory.getAndNameTransaction(contextMgr, "SystemTransaction");
        TransactionManager internal_xact = tc.getInternalTransaction();
        if (SanityManager.DEBUG_ON("verbose_btree_post_commit")) {
            System.out.println("starting internal xact\n");
        }
        OpenBTree open_btree = null;
        try {
            open_btree = this.openIndex(internal_xact, 7, 2);
            DataValueDescriptor[] shrink_key = this.purgeCommittedDeletes(open_btree, this.page_number);
            if (shrink_key != null) {
                this.doShrink(open_btree, shrink_key);
            }
        }
        catch (StandardException se) {
            if (se.isLockTimeoutOrDeadlock()) {
                try {
                    open_btree = this.openIndex(internal_xact, 6, 1);
                    this.purgeRowLevelCommittedDeletes(open_btree);
                }
                catch (StandardException se2) {
                    if (se2.isLockTimeoutOrDeadlock()) {
                        requeue_work = true;
                    }
                }
            }
        }
        finally {
            if (open_btree != null) {
                open_btree.close();
            }
            internal_xact.commit();
            internal_xact.destroy();
        }
        return requeue_work ? 2 : 1;
    }

    private final DataValueDescriptor[] getShrinkKey(OpenBTree open_btree, ControlRow control_row, int slot_no) throws StandardException {
        Object[] shrink_key = open_btree.getConglomerate().createTemplate(open_btree.getRawTran());
        control_row.page.fetchFromSlot(null, slot_no, shrink_key, null, true);
        return shrink_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataValueDescriptor[] purgeCommittedDeletes(OpenBTree open_btree, long pageno) throws StandardException {
        ControlRow control_row = null;
        DataValueDescriptor[] shrink_key = null;
        try {
            control_row = ControlRow.getNoWait(open_btree, pageno);
            if (control_row != null) {
                Page page = control_row.page;
                int num_possible_commit_delete = page.recordCount() - 1 - page.nonDeletedRecordCount();
                if (num_possible_commit_delete > 0) {
                    for (int slot_no = page.recordCount() - 1; slot_no > 0; --slot_no) {
                        if (!page.isDeletedAtSlot(slot_no)) continue;
                        if (page.recordCount() == 2) {
                            shrink_key = this.getShrinkKey(open_btree, control_row, slot_no);
                        }
                        page.purgeAtSlot(slot_no, 1, true);
                        page.setRepositionNeeded();
                        if (!SanityManager.DEBUG_ON("verbose_btree_post_commit")) continue;
                        System.out.println("Purging row[" + slot_no + "]on page:" + pageno + ".\n");
                    }
                }
                if (page.recordCount() == 1 && SanityManager.DEBUG_ON("verbose_btree_post_commit")) {
                    System.out.println("Chance to shrink.\n");
                }
            } else if (SanityManager.DEBUG_ON("verbose_btree_post_commit")) {
                System.out.println("Get No Wait returned null. page num = " + pageno + "\n");
            }
        }
        finally {
            if (control_row != null) {
                control_row.release();
            }
        }
        return shrink_key;
    }

    private final void purgeRowLevelCommittedDeletes(OpenBTree open_btree) throws StandardException {
        LeafControlRow leaf = null;
        leaf = (LeafControlRow)ControlRow.getNoWait(open_btree, this.page_number);
        if (leaf == null) {
            return;
        }
        BTreeLockingPolicy btree_locking_policy = open_btree.getLockingPolicy();
        int num_possible_commit_delete = leaf.page.recordCount() - 1 - leaf.page.nonDeletedRecordCount();
        if (num_possible_commit_delete > 0) {
            DataValueDescriptor[] scratch_template = open_btree.getRuntimeMem().get_template(open_btree.getRawTran());
            Page page = leaf.page;
            FetchDescriptor lock_fetch_desc = RowUtil.getFetchDescriptorConstant(scratch_template.length - 1);
            for (int slot_no = page.recordCount() - 1; slot_no > 0; --slot_no) {
                if (!page.isDeletedAtSlot(slot_no) || !btree_locking_policy.lockScanCommittedDeletedRow(open_btree, leaf, scratch_template, lock_fetch_desc, slot_no)) continue;
                page.purgeAtSlot(slot_no, 1, true);
                page.setRepositionNeeded();
            }
        }
    }
}

