/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import org.apache.datasketches.pig.tuple.ArrayOfDoublesSketchToEstimateAndErrorBounds;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchToEstimateAndErrorBoundsTest {
    static final TupleFactory tupleFactory = TupleFactory.getInstance();

    @Test
    public void nullInput() throws Exception {
        ArrayOfDoublesSketchToEstimateAndErrorBounds func = new ArrayOfDoublesSketchToEstimateAndErrorBounds();
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void emptyInputTuple() throws Exception {
        ArrayOfDoublesSketchToEstimateAndErrorBounds func = new ArrayOfDoublesSketchToEstimateAndErrorBounds();
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void emptyInputSketch() throws Exception {
        ArrayOfDoublesSketchToEstimateAndErrorBounds func = new ArrayOfDoublesSketchToEstimateAndErrorBounds();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple((Object)new DataByteArray(sketch.compact().toByteArray())));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((long)resultTuple.size(), (long)3L);
        Assert.assertEquals((Object)resultTuple.get(0), (Object)0.0);
        Assert.assertEquals((Object)resultTuple.get(1), (Object)0.0);
        Assert.assertEquals((Object)resultTuple.get(2), (Object)0.0);
    }

    @Test
    public void nonEmptyInputSketchExactMode() throws Exception {
        ArrayOfDoublesSketchToEstimateAndErrorBounds func = new ArrayOfDoublesSketchToEstimateAndErrorBounds();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{0.0});
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple((Object)new DataByteArray(sketch.compact().toByteArray())));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((long)resultTuple.size(), (long)3L);
        Assert.assertEquals((Object)resultTuple.get(0), (Object)1.0);
        Assert.assertEquals((Object)resultTuple.get(1), (Object)1.0);
        Assert.assertEquals((Object)resultTuple.get(2), (Object)1.0);
    }

    @Test
    public void nonEmptyInputSketchEstimationMode() throws Exception {
        ArrayOfDoublesSketchToEstimateAndErrorBounds func = new ArrayOfDoublesSketchToEstimateAndErrorBounds();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        int numKeys = 10000;
        for (int i = 0; i < numKeys; ++i) {
            sketch.update((long)i, new double[]{0.0});
        }
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple((Object)new DataByteArray(sketch.compact().toByteArray())));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((long)resultTuple.size(), (long)3L);
        double estimate = (Double)resultTuple.get(0);
        double lowerBound = (Double)resultTuple.get(1);
        double upperBound = (Double)resultTuple.get(2);
        Assert.assertEquals((double)estimate, (double)numKeys, (double)((double)numKeys * 0.04));
        Assert.assertEquals((double)lowerBound, (double)numKeys, (double)((double)numKeys * 0.04));
        Assert.assertEquals((double)upperBound, (double)numKeys, (double)((double)numKeys * 0.04));
        Assert.assertTrue((lowerBound < estimate ? 1 : 0) != 0);
        Assert.assertTrue((upperBound > estimate ? 1 : 0) != 0);
    }
}

