/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.thetacommon.ThetaUtil;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.arrayofdoubles.HeapArrayOfDoublesQuickSelectSketch;

public class ArrayOfDoublesUpdatableSketchBuilder {
    private int nomEntries_ = 4096;
    private ResizeFactor resizeFactor_ = DEFAULT_RESIZE_FACTOR;
    private int numValues_ = 1;
    private float samplingProbability_ = 1.0f;
    private long seed_ = 9001L;
    private static final int DEFAULT_NUMBER_OF_VALUES = 1;
    private static final float DEFAULT_SAMPLING_PROBABILITY = 1.0f;
    private static final ResizeFactor DEFAULT_RESIZE_FACTOR = ResizeFactor.X8;

    public ArrayOfDoublesUpdatableSketchBuilder setNominalEntries(int nomEntries) {
        this.nomEntries_ = 1 << ThetaUtil.checkNomLongs(nomEntries);
        return this;
    }

    public ArrayOfDoublesUpdatableSketchBuilder setResizeFactor(ResizeFactor resizeFactor) {
        this.resizeFactor_ = resizeFactor;
        return this;
    }

    public ArrayOfDoublesUpdatableSketchBuilder setSamplingProbability(float samplingProbability) {
        if (samplingProbability < 0.0f || samplingProbability > 1.0f) {
            throw new SketchesArgumentException("sampling probability must be between 0 and 1");
        }
        this.samplingProbability_ = samplingProbability;
        return this;
    }

    public ArrayOfDoublesUpdatableSketchBuilder setNumberOfValues(int numValues) {
        this.numValues_ = numValues;
        return this;
    }

    public ArrayOfDoublesUpdatableSketchBuilder setSeed(long seed) {
        this.seed_ = seed;
        return this;
    }

    public ArrayOfDoublesUpdatableSketch build() {
        return new HeapArrayOfDoublesQuickSelectSketch(this.nomEntries_, this.resizeFactor_.lg(), this.samplingProbability_, this.numValues_, this.seed_);
    }

    public ArrayOfDoublesUpdatableSketch build(WritableMemory dstMem) {
        return new DirectArrayOfDoublesQuickSelectSketch(this.nomEntries_, this.resizeFactor_.lg(), this.samplingProbability_, this.numValues_, this.seed_, dstMem);
    }
}

