/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.partitions;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.partitions.BoundsRule;
import org.apache.datasketches.partitions.SketchFillRequest;
import org.apache.datasketches.quantilescommon.LongsAsOrderableStrings;

public class KllItemsSketchFillRequestLongAsString
implements SketchFillRequest<String, KllItemsSketch<String>> {
    private int k;
    private int numDigits;

    public KllItemsSketchFillRequestLongAsString() {
        this.k = 1024;
        this.numDigits = 3;
    }

    public KllItemsSketchFillRequestLongAsString(int k, long totalN) {
        this.k = k;
        this.numDigits = LongsAsOrderableStrings.digits(totalN);
    }

    public KllItemsSketch<String> getRange(String lowerQuantile, String upperQuantile, BoundsRule bounds) {
        long upper;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)this.k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        try {
            long lower = Long.parseLong(lowerQuantile.trim());
            upper = Long.parseLong(upperQuantile.trim());
        }
        catch (NumberFormatException e) {
            throw new SketchesArgumentException(e.toString());
        }
        if (bounds == BoundsRule.INCLUDE_BOTH) {
            for (long i = lower; i <= upper; ++i) {
                sk.update((Object)LongsAsOrderableStrings.getString(i, this.numDigits));
            }
        } else if (bounds == BoundsRule.INCLUDE_UPPER) {
            for (long i = lower + 1L; i <= upper; ++i) {
                sk.update((Object)LongsAsOrderableStrings.getString(i, this.numDigits));
            }
        } else {
            for (long i = lower; i < upper; ++i) {
                sk.update((Object)LongsAsOrderableStrings.getString(i, this.numDigits));
            }
        }
        return sk;
    }

    public KllItemsSketch<String> getRange(long lowerQuantile, long upperQuantile, BoundsRule bounds) {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)this.k, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        long lower = lowerQuantile;
        long upper = upperQuantile;
        if (bounds == BoundsRule.INCLUDE_BOTH) {
            for (long i = lower; i <= upper; ++i) {
                sk.update((Object)LongsAsOrderableStrings.getString(i, this.numDigits));
            }
        } else if (bounds == BoundsRule.INCLUDE_UPPER) {
            for (long i = lower + 1L; i <= upper; ++i) {
                sk.update((Object)LongsAsOrderableStrings.getString(i, this.numDigits));
            }
        } else {
            for (long i = lower; i < upper; ++i) {
                sk.update((Object)LongsAsOrderableStrings.getString(i, this.numDigits));
            }
        }
        return sk;
    }
}

