/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hll.AbstractCoupons;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HllSketchTest {
    @Test
    public void checkCopies() {
        HllSketchTest.runCheckCopy(14, TgtHllType.HLL_4, null);
        HllSketchTest.runCheckCopy(8, TgtHllType.HLL_6, null);
        HllSketchTest.runCheckCopy(8, TgtHllType.HLL_8, null);
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)14, (TgtHllType)TgtHllType.HLL_8);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketchTest.runCheckCopy(14, TgtHllType.HLL_4, wmem);
        HllSketchTest.runCheckCopy(8, TgtHllType.HLL_6, wmem);
        HllSketchTest.runCheckCopy(8, TgtHllType.HLL_8, wmem);
    }

    private static void runCheckCopy(int lgConfigK, TgtHllType tgtHllType, WritableMemory wmem) {
        HllSketch sk = wmem == null ? new HllSketch(lgConfigK, tgtHllType) : new HllSketch(lgConfigK, tgtHllType, wmem);
        for (int i = 0; i < 7; ++i) {
            sk.update((long)i);
        }
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.LIST);
        HllSketch skCopy = sk.copy();
        Assert.assertEquals((Object)skCopy.getCurMode(), (Object)CurMode.LIST);
        HllSketchImpl impl1 = sk.hllSketchImpl;
        HllSketchImpl impl2 = skCopy.hllSketchImpl;
        AbstractCoupons absCoupons1 = (AbstractCoupons)sk.hllSketchImpl;
        AbstractCoupons absCoupons2 = (AbstractCoupons)skCopy.hllSketchImpl;
        Assert.assertEquals((int)absCoupons1.getCouponCount(), (int)absCoupons2.getCouponCount());
        Assert.assertEquals((double)impl1.getEstimate(), (double)impl2.getEstimate(), (double)0.0);
        Assert.assertFalse((impl1 == impl2 ? 1 : 0) != 0);
        for (int i = 7; i < 24; ++i) {
            sk.update((long)i);
        }
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.SET);
        skCopy = sk.copy();
        Assert.assertEquals((Object)skCopy.getCurMode(), (Object)CurMode.SET);
        impl1 = sk.hllSketchImpl;
        impl2 = skCopy.hllSketchImpl;
        absCoupons1 = (AbstractCoupons)sk.hllSketchImpl;
        absCoupons2 = (AbstractCoupons)skCopy.hllSketchImpl;
        Assert.assertEquals((int)absCoupons1.getCouponCount(), (int)absCoupons2.getCouponCount());
        Assert.assertEquals((double)impl1.getEstimate(), (double)impl2.getEstimate(), (double)0.0);
        Assert.assertFalse((impl1 == impl2 ? 1 : 0) != 0);
        int u = sk.getTgtHllType() == TgtHllType.HLL_4 ? 100000 : 25;
        for (int i = 24; i < u; ++i) {
            sk.update((long)i);
        }
        sk.getCompactSerializationBytes();
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.HLL);
        skCopy = sk.copy();
        Assert.assertEquals((Object)skCopy.getCurMode(), (Object)CurMode.HLL);
        impl1 = sk.hllSketchImpl;
        impl2 = skCopy.hllSketchImpl;
        Assert.assertEquals((double)impl1.getEstimate(), (double)impl2.getEstimate(), (double)0.0);
        Assert.assertFalse((impl1 == impl2 ? 1 : 0) != 0);
    }

    @Test
    public void checkCopyAs() {
        HllSketchTest.copyAs(TgtHllType.HLL_4, TgtHllType.HLL_4, false);
        HllSketchTest.copyAs(TgtHllType.HLL_4, TgtHllType.HLL_6, false);
        HllSketchTest.copyAs(TgtHllType.HLL_4, TgtHllType.HLL_8, false);
        HllSketchTest.copyAs(TgtHllType.HLL_6, TgtHllType.HLL_4, false);
        HllSketchTest.copyAs(TgtHllType.HLL_6, TgtHllType.HLL_6, false);
        HllSketchTest.copyAs(TgtHllType.HLL_6, TgtHllType.HLL_8, false);
        HllSketchTest.copyAs(TgtHllType.HLL_8, TgtHllType.HLL_4, false);
        HllSketchTest.copyAs(TgtHllType.HLL_8, TgtHllType.HLL_6, false);
        HllSketchTest.copyAs(TgtHllType.HLL_8, TgtHllType.HLL_8, false);
        HllSketchTest.copyAs(TgtHllType.HLL_4, TgtHllType.HLL_4, true);
        HllSketchTest.copyAs(TgtHllType.HLL_4, TgtHllType.HLL_6, true);
        HllSketchTest.copyAs(TgtHllType.HLL_4, TgtHllType.HLL_8, true);
        HllSketchTest.copyAs(TgtHllType.HLL_6, TgtHllType.HLL_4, true);
        HllSketchTest.copyAs(TgtHllType.HLL_6, TgtHllType.HLL_6, true);
        HllSketchTest.copyAs(TgtHllType.HLL_6, TgtHllType.HLL_8, true);
        HllSketchTest.copyAs(TgtHllType.HLL_8, TgtHllType.HLL_4, true);
        HllSketchTest.copyAs(TgtHllType.HLL_8, TgtHllType.HLL_6, true);
        HllSketchTest.copyAs(TgtHllType.HLL_8, TgtHllType.HLL_8, true);
    }

    private static void copyAs(TgtHllType srcType, TgtHllType dstType, boolean direct) {
        int i;
        int lgK = 8;
        int n1 = 7;
        int n2 = 24;
        int n3 = 1000;
        int base = 0;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)srcType);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch src = direct ? new HllSketch(lgK, srcType, wmem) : new HllSketch(lgK, srcType);
        for (int i2 = 0; i2 < n1; ++i2) {
            src.update((long)(i2 + base));
        }
        HllSketch dst = src.copyAs(dstType);
        Assert.assertEquals((double)dst.getEstimate(), (double)src.getEstimate(), (double)0.0);
        for (i = n1; i < n2; ++i) {
            src.update((long)i);
        }
        dst = src.copyAs(dstType);
        Assert.assertEquals((double)dst.getEstimate(), (double)src.getEstimate(), (double)0.0);
        for (i = n2; i < n3; ++i) {
            src.update((long)i);
        }
        dst = src.copyAs(dstType);
        Assert.assertEquals((double)dst.getEstimate(), (double)src.getEstimate(), (double)0.0);
    }

    @Test
    public void checkMisc1() {
        HllSketchTest.misc(false);
        HllSketchTest.misc(true);
    }

    private static void misc(boolean direct) {
        int lgConfigK = 8;
        TgtHllType srcType = TgtHllType.HLL_8;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgConfigK, (TgtHllType)srcType);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = direct ? new HllSketch(lgConfigK, srcType, wmem) : new HllSketch(lgConfigK, srcType);
        for (int i = 0; i < 7; ++i) {
            sk.update((long)i);
        }
        AbstractCoupons absCoupons = (AbstractCoupons)sk.hllSketchImpl;
        Assert.assertEquals((int)absCoupons.getCouponCount(), (int)7);
        Assert.assertEquals((int)sk.getCompactSerializationBytes(), (int)36);
        Assert.assertEquals((int)sk.getUpdatableSerializationBytes(), (int)40);
        for (int i = 7; i < 24; ++i) {
            sk.update((long)i);
        }
        absCoupons = (AbstractCoupons)sk.hllSketchImpl;
        Assert.assertEquals((int)absCoupons.getCouponCount(), (int)24);
        Assert.assertEquals((int)sk.getCompactSerializationBytes(), (int)108);
        Assert.assertEquals((int)sk.getUpdatableSerializationBytes(), (int)140);
        sk.update(24L);
        AbstractHllArray absHll = (AbstractHllArray)sk.hllSketchImpl;
        Assert.assertNull((Object)absHll.getAuxIterator());
        Assert.assertEquals((int)absHll.getCurMin(), (int)0);
        Assert.assertEquals((double)absHll.getHipAccum(), (double)25.0, (double)0.5);
        Assert.assertTrue((absHll.getNumAtCurMin() >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)sk.getUpdatableSerializationBytes(), (int)296);
        Assert.assertEquals((int)absHll.getMemDataStart(), (int)40);
        Assert.assertEquals((int)absHll.getPreInts(), (int)10);
        int hllBytes = PreambleUtil.HLL_BYTE_ARR_START + (1 << lgConfigK);
        Assert.assertEquals((int)sk.getCompactSerializationBytes(), (int)hllBytes);
        Assert.assertEquals((int)HllSketch.getMaxUpdatableSerializationBytes((int)lgConfigK, (TgtHllType)TgtHllType.HLL_8), (int)hllBytes);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNumStdDev() {
        HllUtil.checkNumStdDev((int)0);
    }

    @Test
    public void checkSerSizes() {
        HllSketchTest.checkSerSizes(8, TgtHllType.HLL_8, false);
        HllSketchTest.checkSerSizes(8, TgtHllType.HLL_8, true);
        HllSketchTest.checkSerSizes(8, TgtHllType.HLL_6, false);
        HllSketchTest.checkSerSizes(8, TgtHllType.HLL_6, true);
        HllSketchTest.checkSerSizes(8, TgtHllType.HLL_4, false);
        HllSketchTest.checkSerSizes(8, TgtHllType.HLL_4, true);
    }

    private static void checkSerSizes(int lgConfigK, TgtHllType tgtHllType, boolean direct) {
        int i;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgConfigK, (TgtHllType)tgtHllType);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = direct ? new HllSketch(lgConfigK, tgtHllType, wmem) : new HllSketch(lgConfigK, tgtHllType);
        for (i = 0; i < 7; ++i) {
            sk.update((long)i);
        }
        int expected = PreambleUtil.LIST_INT_ARR_START + (i << 2);
        Assert.assertEquals((int)sk.getCompactSerializationBytes(), (int)expected);
        expected = PreambleUtil.LIST_INT_ARR_START + 32;
        Assert.assertEquals((int)sk.getUpdatableSerializationBytes(), (int)expected);
        for (i = 7; i < 24; ++i) {
            sk.update((long)i);
        }
        expected = PreambleUtil.HASH_SET_INT_ARR_START + (i << 2);
        Assert.assertEquals((int)sk.getCompactSerializationBytes(), (int)expected);
        expected = PreambleUtil.HASH_SET_INT_ARR_START + 128;
        Assert.assertEquals((int)sk.getUpdatableSerializationBytes(), (int)expected);
        sk.update((long)i);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.HLL);
        AbstractHllArray absHll = (AbstractHllArray)sk.hllSketchImpl;
        int auxCountBytes = 0;
        int auxArrBytes = 0;
        if (absHll.tgtHllType == TgtHllType.HLL_4) {
            AuxHashMap auxMap = absHll.getAuxHashMap();
            if (auxMap != null) {
                auxCountBytes = auxMap.getAuxCount() << 2;
                auxArrBytes = 4 << auxMap.getLgAuxArrInts();
            } else {
                auxArrBytes = 4 << HllUtil.LG_AUX_ARR_INTS[lgConfigK];
            }
        }
        int hllArrBytes = absHll.getHllByteArrBytes();
        expected = PreambleUtil.HLL_BYTE_ARR_START + hllArrBytes + auxCountBytes;
        Assert.assertEquals((int)sk.getCompactSerializationBytes(), (int)expected);
        expected = PreambleUtil.HLL_BYTE_ARR_START + hllArrBytes + auxArrBytes;
        Assert.assertEquals((int)sk.getUpdatableSerializationBytes(), (int)expected);
        int fullAuxBytes = tgtHllType == TgtHllType.HLL_4 ? 4 << HllUtil.LG_AUX_ARR_INTS[lgConfigK] : 0;
        expected = PreambleUtil.HLL_BYTE_ARR_START + hllArrBytes + fullAuxBytes;
        Assert.assertEquals((int)HllSketch.getMaxUpdatableSerializationBytes((int)lgConfigK, (TgtHllType)tgtHllType), (int)expected);
    }

    @Test
    public void checkConfigKLimits() {
        HllSketch sk2;
        try {
            sk2 = new HllSketch(3);
            Assert.fail();
        }
        catch (SketchesArgumentException sk2) {
            // empty catch block
        }
        try {
            sk2 = new HllSketch(22);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void exerciseToStringDetails() {
        int i;
        HllSketch sk = new HllSketch(15, TgtHllType.HLL_4);
        for (i = 0; i < 25; ++i) {
            sk.update((long)i);
        }
        HllSketchTest.println(sk.toString(false, true, true, true));
        for (i = 25; i < 4096; ++i) {
            sk.update((long)i);
        }
        HllSketchTest.println(sk.toString(false, true, true, true));
        for (i = 4096; i < 32768; ++i) {
            sk.update((long)i);
        }
        HllSketchTest.println(sk.toString(false, true, true, true));
        HllSketchTest.println(sk.toString(false, true, true, false));
        HllSketchTest.println(sk.toString(false, true, true));
        sk = new HllSketch(8, TgtHllType.HLL_6);
        for (i = 0; i < 25; ++i) {
            sk.update((long)i);
        }
        HllSketchTest.println(sk.toString(false, true, true, true));
    }

    @Test
    public void checkMemoryNotLargeEnough() {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)8, (TgtHllType)TgtHllType.HLL_8);
        WritableMemory wmem = WritableMemory.allocate((int)(bytes - 1));
        try {
            HllSketch sk = new HllSketch(8, TgtHllType.HLL_8, wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkEmptyCoupon() {
        int lgK = 8;
        TgtHllType type = TgtHllType.HLL_8;
        HllSketch sk = new HllSketch(lgK, type);
        for (int i = 0; i < 20; ++i) {
            sk.update((long)i);
        }
        sk.couponUpdate(0);
        Assert.assertEquals((double)sk.getEstimate(), (double)20.0, (double)0.001);
    }

    @Test
    public void checkCompactFlag() {
        int lgK = 8;
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 7, TgtHllType.HLL_8, false, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 7, TgtHllType.HLL_8, false, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 7, TgtHllType.HLL_8, false, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 7, TgtHllType.HLL_8, false, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 7, TgtHllType.HLL_8, true, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 7, TgtHllType.HLL_8, true, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 7, TgtHllType.HLL_8, true, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 7, TgtHllType.HLL_8, true, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 24, TgtHllType.HLL_8, false, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 24, TgtHllType.HLL_8, false, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 24, TgtHllType.HLL_8, false, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 24, TgtHllType.HLL_8, false, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 24, TgtHllType.HLL_8, true, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 24, TgtHllType.HLL_8, true, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 24, TgtHllType.HLL_8, true, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 24, TgtHllType.HLL_8, true, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_8, false, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_8, false, true), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_8, false, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_8, false, true), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_8, true, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_8, true, true), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_8, true, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_8, true, true), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_6, false, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_6, false, true), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_6, false, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_6, false, true), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_6, true, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_6, true, true), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_6, true, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_6, true, true), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_4, false, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_4, false, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_4, false, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_4, false, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_4, true, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_4, true, true), (boolean)true);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_4, true, false), (boolean)false);
        Assert.assertEquals((boolean)HllSketchTest.checkCompact(lgK, 25, TgtHllType.HLL_4, true, true), (boolean)true);
    }

    private static boolean checkCompact(int lgK, int n, TgtHllType type, boolean direct, boolean compact) {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)type);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = direct ? new HllSketch(lgK, type, wmem) : new HllSketch(lgK, type);
        Assert.assertEquals((boolean)sk.isMemory(), (boolean)direct);
        Assert.assertFalse((boolean)sk.isOffHeap());
        for (int i = 0; i < n; ++i) {
            sk.update((long)i);
        }
        byte[] byteArr = compact ? sk.toCompactByteArray() : sk.toUpdatableByteArray();
        int len = byteArr.length;
        if (compact) {
            Assert.assertEquals((int)len, (int)sk.getCompactSerializationBytes());
        } else {
            Assert.assertEquals((int)len, (int)sk.getUpdatableSerializationBytes());
        }
        HllSketch sk2 = HllSketch.wrap((Memory)Memory.wrap((byte[])byteArr));
        Assert.assertEquals((double)sk2.getEstimate(), (double)n, (double)0.01);
        boolean resourceCompact = sk2.isCompact();
        if (resourceCompact) {
            try {
                HllSketch.writableWrap((WritableMemory)WritableMemory.writableWrap((byte[])byteArr));
                Assert.fail();
            }
            catch (SketchesArgumentException sketchesArgumentException) {
                // empty catch block
            }
        }
        return resourceCompact;
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWritableWrapOfCompact() {
        HllSketch sk = new HllSketch();
        byte[] byteArr = sk.toCompactByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        HllSketch sk2 = HllSketch.writableWrap((WritableMemory)wmem);
    }

    @Test
    public void checkJavadocExample() {
        int lgK = 12;
        HllSketch sk = new HllSketch(lgK, TgtHllType.HLL_4);
        for (int i = 0; i < 2 << lgK; ++i) {
            sk.update((long)i);
        }
        byte[] arr = sk.toCompactByteArray();
        Union union = Union.heapify((byte[])arr);
        union = Union.heapify((Memory)Memory.wrap((byte[])arr));
        HllSketch sk2 = HllSketch.heapify((byte[])arr);
        sk2 = HllSketch.heapify((Memory)Memory.wrap((byte[])arr));
    }

    @Test
    public void printlnTest() {
        HllSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void print(String s) {
    }

    static void println(String s) {
    }
}

