/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.hive.cpc.SketchToStringUDF;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchToStringUDFTest {
    @Test
    public void nullSketch() {
        String result = new SketchToStringUDF().evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketch() {
        CpcSketch sketch = new CpcSketch();
        String result = new SketchToStringUDF().evaluate(new BytesWritable(sketch.toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void normalCase() {
        CpcSketch sketch = new CpcSketch();
        sketch.update(1L);
        sketch.update(2L);
        String result = new SketchToStringUDF().evaluate(new BytesWritable(sketch.toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void customSeed() {
        long seed = 123L;
        CpcSketch sketch = new CpcSketch(12, 123L);
        sketch.update(1L);
        sketch.update(2L);
        String result = new SketchToStringUDF().evaluate(new BytesWritable(sketch.toByteArray()), 123L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.length() > 0 ? 1 : 0) != 0);
    }
}

