/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.concurrent.UncheckedFuture;
import org.junit.jupiter.api.Test;

class ToStringStyleConcurrencyTest
extends AbstractLangTest {
    private static final List<Integer> LIST = new ArrayList<Integer>(100000);
    private static final int LIST_SIZE = 100000;
    private static final int REPEAT = 100;

    ToStringStyleConcurrencyTest() {
    }

    @Test
    void testArrayList() throws InterruptedException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new ArrayList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrency(CollectionHolder<List<Integer>> holder) throws InterruptedException {
        List list = (List)holder.collection;
        list.addAll(LIST);
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        try {
            Callable<Integer> consumer = () -> {
                for (int i = 0; i < 100; ++i) {
                    new ToStringBuilder((Object)holder).append(holder.collection);
                }
                return 100;
            };
            ArrayList<Callable<Integer>> tasks = new ArrayList<Callable<Integer>>();
            tasks.add(consumer);
            tasks.add(consumer);
            List futures = threadPool.invokeAll(tasks);
            UncheckedFuture.on(futures).forEach(UncheckedFuture::get);
        }
        finally {
            threadPool.shutdown();
            threadPool.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    void testCopyOnWriteArrayList() throws InterruptedException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new CopyOnWriteArrayList()));
    }

    @Test
    void testLinkedList() throws InterruptedException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new LinkedList()));
    }

    static {
        for (int i = 0; i < 100000; ++i) {
            LIST.add(i);
        }
    }

    static class CollectionHolder<T extends Collection<?>> {
        T collection;

        CollectionHolder(T collection) {
            this.collection = collection;
        }
    }
}

