/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.TestBasicDataSource;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.apache.commons.dbcp2.managed.TesterBasicXAConnection;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDataSourceXAConnectionFactory
extends TestBasicDataSource {
    protected BasicManagedDataSource bmds;
    public final AtomicInteger closeCounter = new AtomicInteger();

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.bmds = new BasicManagedDataSource();
        this.bmds.setTransactionManager((TransactionManager)new TransactionManagerImpl());
        this.bmds.setXADataSource("notnull");
        XADataSourceHandle handle = new XADataSourceHandle();
        XADataSource xads = (XADataSource)Proxy.newProxyInstance(XADataSourceHandle.class.getClassLoader(), new Class[]{XADataSource.class}, (InvocationHandler)handle);
        this.bmds.setXaDataSourceInstance(xads);
    }

    @Test
    void testPhysicalClose() throws Exception {
        this.bmds.setMaxIdle(1);
        Connection conn1 = this.bmds.getConnection();
        Connection conn2 = this.bmds.getConnection();
        this.closeCounter.set(0);
        conn1.close();
        Assertions.assertEquals((int)0, (int)this.closeCounter.get());
        conn2.close();
        Assertions.assertEquals((int)1, (int)this.closeCounter.get());
        this.bmds.close();
        Assertions.assertEquals((int)2, (int)this.closeCounter.get());
    }

    public final class XADataSourceHandle
    implements InvocationHandler {
        protected XAConnection getXAConnection() throws SQLException {
            return new TesterBasicXAConnection(TestDataSourceXAConnectionFactory.this.ds.getConnection(), TestDataSourceXAConnectionFactory.this.closeCounter);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            switch (methodName = method.getName()) {
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "equals": {
                    return proxy == args[0];
                }
                case "getXAConnection": {
                    return this.getXAConnection();
                }
            }
            try {
                return method.invoke((Object)TestDataSourceXAConnectionFactory.this.ds, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

