/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.DigraphIteration;

public class InOutBreadthFirstSearch
extends Algorithm {
    private DigraphIteration factory;
    private Object firstVertex;
    private Buffer queue = new UnboundedFifoBuffer();
    private Set seen = new HashSet();

    public InOutBreadthFirstSearch(DigraphIteration factory, Object firstVertex) {
        this.factory = factory;
        this.reset(firstVertex);
    }

    public void reset(Object newFirstVertex) {
        if (!this.queue.isEmpty()) {
            this.queue.clear();
        }
        if (!this.seen.isEmpty()) {
            this.seen.clear();
        }
        this.firstVertex = newFirstVertex;
        this.queue.add(this.firstVertex);
        this.seen.add(this.firstVertex);
    }

    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    public Object next() {
        Object currentVertex = this.queue.remove();
        ArcIterator i = this.factory.outgoingIterator(currentVertex);
        Object origin = i.getOrigin();
        while (i.hasNext()) {
            i.next();
            Object dst = i.getDestination();
            if (!this.seen.add(dst)) continue;
            this.queue.add(dst);
        }
        i = this.factory.incomingIterator(currentVertex);
        while (i.hasNext()) {
            i.next();
            Object org = i.getOrigin();
            if (!this.seen.add(org)) continue;
            this.queue.add(org);
        }
        return origin;
    }

    public Set getSeenVertices() {
        return Collections.unmodifiableSet(this.seen);
    }
}

