/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.sql.ResultSet;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.select.RowReader;
import org.apache.cayenne.exp.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityTreeRowReader
implements RowReader<Object> {
    private RowReader<?> discriminatorReader;
    private Expression[] entityQualifiers;
    private RowReader<Object>[] entityReaders;

    EntityTreeRowReader(RowReader<?> discriminatorReader, Expression[] entityQualifiers, RowReader<Object>[] entityReaders) {
        this.discriminatorReader = discriminatorReader;
        this.entityQualifiers = entityQualifiers;
        this.entityReaders = entityReaders;
    }

    @Override
    public void setColumnOffset(int offset) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Object readRow(ResultSet resultSet) throws CayenneException {
        Map discriminator = (Map)this.discriminatorReader.readRow(resultSet);
        int len = this.entityQualifiers.length;
        for (int i = len - 1; i >= 0; --i) {
            if (!this.entityQualifiers[i].match(discriminator)) continue;
            return this.entityReaders[i].readRow(resultSet);
        }
        throw new CayenneException("Row discriminator did not match any entities in the inheritance hierarchy: " + discriminator);
    }
}

