/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.PetSetSpec;
import io.fabric8.kubernetes.api.model.extensions.PetSetSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.PetSetSpecFluentImpl;

public class PetSetSpecBuilder
extends PetSetSpecFluentImpl<PetSetSpecBuilder>
implements VisitableBuilder<PetSetSpec, PetSetSpecBuilder> {
    PetSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PetSetSpecBuilder() {
        this(true);
    }

    public PetSetSpecBuilder(Boolean validationEnabled) {
        this(new PetSetSpec(), validationEnabled);
    }

    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PetSetSpec(), validationEnabled);
    }

    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent, PetSetSpec instance) {
        this(fluent, instance, true);
    }

    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent, PetSetSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
        fluent.withServiceName(instance.getServiceName());
        fluent.withTemplate(instance.getTemplate());
        fluent.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
        this.validationEnabled = validationEnabled;
    }

    public PetSetSpecBuilder(PetSetSpec instance) {
        this(instance, (Boolean)true);
    }

    public PetSetSpecBuilder(PetSetSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withServiceName(instance.getServiceName());
        this.withTemplate(instance.getTemplate());
        this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PetSetSpec build() {
        PetSetSpec buildable = new PetSetSpec(this.fluent.getReplicas(), this.fluent.getSelector(), this.fluent.getServiceName(), this.fluent.getTemplate(), this.fluent.getVolumeClaimTemplates());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PetSetSpecBuilder that = (PetSetSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

