/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.beam.sdk.io.thrift;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
@javax.annotation.Generated(
    value = "Autogenerated by Thrift Compiler (0.13.0)",
    date = "2020-12-12")
public class TestThriftStruct
    implements org.apache.thrift.TBase<TestThriftStruct, TestThriftStruct._Fields>,
        java.io.Serializable,
        Cloneable,
        Comparable<TestThriftStruct> {
  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC =
      new org.apache.thrift.protocol.TStruct("TestThriftStruct");

  private static final org.apache.thrift.protocol.TField TEST_BYTE_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testByte", org.apache.thrift.protocol.TType.BYTE, (short) 1);
  private static final org.apache.thrift.protocol.TField TEST_SHORT_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testShort", org.apache.thrift.protocol.TType.I16, (short) 2);
  private static final org.apache.thrift.protocol.TField TEST_INT_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testInt", org.apache.thrift.protocol.TType.I32, (short) 3);
  private static final org.apache.thrift.protocol.TField TEST_LONG_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testLong", org.apache.thrift.protocol.TType.I64, (short) 4);
  private static final org.apache.thrift.protocol.TField TEST_DOUBLE_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testDouble", org.apache.thrift.protocol.TType.DOUBLE, (short) 5);
  private static final org.apache.thrift.protocol.TField STRING_INT_MAP_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "stringIntMap", org.apache.thrift.protocol.TType.MAP, (short) 6);
  private static final org.apache.thrift.protocol.TField TEST_BINARY_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testBinary", org.apache.thrift.protocol.TType.STRING, (short) 7);
  private static final org.apache.thrift.protocol.TField TEST_BOOL_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testBool", org.apache.thrift.protocol.TType.BOOL, (short) 8);
  private static final org.apache.thrift.protocol.TField TEST_LIST_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testList", org.apache.thrift.protocol.TType.LIST, (short) 9);
  private static final org.apache.thrift.protocol.TField TEST_STRING_SET_TYPEDEF_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testStringSetTypedef", org.apache.thrift.protocol.TType.SET, (short) 10);
  private static final org.apache.thrift.protocol.TField TEST_ENUM_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testEnum", org.apache.thrift.protocol.TType.I32, (short) 11);
  private static final org.apache.thrift.protocol.TField TEST_NESTED_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testNested", org.apache.thrift.protocol.TType.STRUCT, (short) 12);
  private static final org.apache.thrift.protocol.TField TEST_UNION_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testUnion", org.apache.thrift.protocol.TType.STRUCT, (short) 13);

  private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY =
      new TestThriftStructStandardSchemeFactory();
  private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY =
      new TestThriftStructTupleSchemeFactory();

  private byte testByte; // required
  private short testShort; // required
  private int testInt; // required
  private long testLong; // required
  private double testDouble; // required
  private @org.apache.thrift.annotation.Nullable java.util.Map<java.lang.String, java.lang.Short>
      stringIntMap; // required
  private @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer testBinary; // required
  private boolean testBool; // required
  private @org.apache.thrift.annotation.Nullable java.util.List<java.lang.Integer>
      testList; // required
  private @org.apache.thrift.annotation.Nullable java.util.Set<java.lang.String>
      testStringSetTypedef; // required
  private @org.apache.thrift.annotation.Nullable TestThriftEnum testEnum; // required
  private @org.apache.thrift.annotation.Nullable TestThriftInnerStruct testNested; // required
  private @org.apache.thrift.annotation.Nullable TestThriftUnion testUnion; // required

  /**
   * The set of fields this struct contains, along with convenience methods for finding and
   * manipulating them.
   */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    TEST_BYTE((short) 1, "testByte"),
    TEST_SHORT((short) 2, "testShort"),
    TEST_INT((short) 3, "testInt"),
    TEST_LONG((short) 4, "testLong"),
    TEST_DOUBLE((short) 5, "testDouble"),
    STRING_INT_MAP((short) 6, "stringIntMap"),
    TEST_BINARY((short) 7, "testBinary"),
    TEST_BOOL((short) 8, "testBool"),
    TEST_LIST((short) 9, "testList"),
    TEST_STRING_SET_TYPEDEF((short) 10, "testStringSetTypedef"),
    /** @see TestThriftEnum */
    TEST_ENUM((short) 11, "testEnum"),
    TEST_NESTED((short) 12, "testNested"),
    TEST_UNION((short) 13, "testUnion");

    private static final java.util.Map<java.lang.String, _Fields> byName =
        new java.util.HashMap<java.lang.String, _Fields>();

    static {
      for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }

    /** Find the _Fields constant that matches fieldId, or null if its not found. */
    @org.apache.thrift.annotation.Nullable
    public static _Fields findByThriftId(int fieldId) {
      switch (fieldId) {
        case 1: // TEST_BYTE
          return TEST_BYTE;
        case 2: // TEST_SHORT
          return TEST_SHORT;
        case 3: // TEST_INT
          return TEST_INT;
        case 4: // TEST_LONG
          return TEST_LONG;
        case 5: // TEST_DOUBLE
          return TEST_DOUBLE;
        case 6: // STRING_INT_MAP
          return STRING_INT_MAP;
        case 7: // TEST_BINARY
          return TEST_BINARY;
        case 8: // TEST_BOOL
          return TEST_BOOL;
        case 9: // TEST_LIST
          return TEST_LIST;
        case 10: // TEST_STRING_SET_TYPEDEF
          return TEST_STRING_SET_TYPEDEF;
        case 11: // TEST_ENUM
          return TEST_ENUM;
        case 12: // TEST_NESTED
          return TEST_NESTED;
        case 13: // TEST_UNION
          return TEST_UNION;
        default:
          return null;
      }
    }

    /** Find the _Fields constant that matches fieldId, throwing an exception if it is not found. */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null)
        throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /** Find the _Fields constant that matches name, or null if its not found. */
    @org.apache.thrift.annotation.Nullable
    public static _Fields findByName(java.lang.String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final java.lang.String _fieldName;

    _Fields(short thriftId, java.lang.String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public java.lang.String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __TESTBYTE_ISSET_ID = 0;
  private static final int __TESTSHORT_ISSET_ID = 1;
  private static final int __TESTINT_ISSET_ID = 2;
  private static final int __TESTLONG_ISSET_ID = 3;
  private static final int __TESTDOUBLE_ISSET_ID = 4;
  private static final int __TESTBOOL_ISSET_ID = 5;
  private byte __isset_bitfield = 0;
  public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;

  static {
    java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap =
        new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
    tmpMap.put(
        _Fields.TEST_BYTE,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testByte",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.BYTE)));
    tmpMap.put(
        _Fields.TEST_SHORT,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testShort",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.I16)));
    tmpMap.put(
        _Fields.TEST_INT,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testInt",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.I32)));
    tmpMap.put(
        _Fields.TEST_LONG,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testLong",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(
        _Fields.TEST_DOUBLE,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testDouble",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.DOUBLE)));
    tmpMap.put(
        _Fields.STRING_INT_MAP,
        new org.apache.thrift.meta_data.FieldMetaData(
            "stringIntMap",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.MapMetaData(
                org.apache.thrift.protocol.TType.MAP,
                new org.apache.thrift.meta_data.FieldValueMetaData(
                    org.apache.thrift.protocol.TType.STRING),
                new org.apache.thrift.meta_data.FieldValueMetaData(
                    org.apache.thrift.protocol.TType.I16))));
    tmpMap.put(
        _Fields.TEST_BINARY,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testBinary",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.STRING, true)));
    tmpMap.put(
        _Fields.TEST_BOOL,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testBool",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.BOOL)));
    tmpMap.put(
        _Fields.TEST_LIST,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testList",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.ListMetaData(
                org.apache.thrift.protocol.TType.LIST,
                new org.apache.thrift.meta_data.FieldValueMetaData(
                    org.apache.thrift.protocol.TType.I32))));
    tmpMap.put(
        _Fields.TEST_STRING_SET_TYPEDEF,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testStringSetTypedef",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.SET, "StringSet")));
    tmpMap.put(
        _Fields.TEST_ENUM,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testEnum",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.EnumMetaData(
                org.apache.thrift.protocol.TType.ENUM, TestThriftEnum.class)));
    tmpMap.put(
        _Fields.TEST_NESTED,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testNested",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.StructMetaData(
                org.apache.thrift.protocol.TType.STRUCT, TestThriftInnerStruct.class)));
    tmpMap.put(
        _Fields.TEST_UNION,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testUnion",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.StructMetaData(
                org.apache.thrift.protocol.TType.STRUCT, TestThriftUnion.class)));
    metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
    org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(
        TestThriftStruct.class, metaDataMap);
  }

  public TestThriftStruct() {}

  public TestThriftStruct(
      byte testByte,
      short testShort,
      int testInt,
      long testLong,
      double testDouble,
      java.util.Map<java.lang.String, java.lang.Short> stringIntMap,
      java.nio.ByteBuffer testBinary,
      boolean testBool,
      java.util.List<java.lang.Integer> testList,
      java.util.Set<java.lang.String> testStringSetTypedef,
      TestThriftEnum testEnum,
      TestThriftInnerStruct testNested,
      TestThriftUnion testUnion) {
    this();
    this.testByte = testByte;
    setTestByteIsSet(true);
    this.testShort = testShort;
    setTestShortIsSet(true);
    this.testInt = testInt;
    setTestIntIsSet(true);
    this.testLong = testLong;
    setTestLongIsSet(true);
    this.testDouble = testDouble;
    setTestDoubleIsSet(true);
    this.stringIntMap = stringIntMap;
    this.testBinary = org.apache.thrift.TBaseHelper.copyBinary(testBinary);
    this.testBool = testBool;
    setTestBoolIsSet(true);
    this.testList = testList;
    this.testStringSetTypedef = testStringSetTypedef;
    this.testEnum = testEnum;
    this.testNested = testNested;
    this.testUnion = testUnion;
  }

  /** Performs a deep copy on <i>other</i>. */
  public TestThriftStruct(TestThriftStruct other) {
    __isset_bitfield = other.__isset_bitfield;
    this.testByte = other.testByte;
    this.testShort = other.testShort;
    this.testInt = other.testInt;
    this.testLong = other.testLong;
    this.testDouble = other.testDouble;
    if (other.isSetStringIntMap()) {
      java.util.Map<java.lang.String, java.lang.Short> __this__stringIntMap =
          new java.util.HashMap<java.lang.String, java.lang.Short>(other.stringIntMap);
      this.stringIntMap = __this__stringIntMap;
    }
    if (other.isSetTestBinary()) {
      this.testBinary = org.apache.thrift.TBaseHelper.copyBinary(other.testBinary);
    }
    this.testBool = other.testBool;
    if (other.isSetTestList()) {
      java.util.List<java.lang.Integer> __this__testList =
          new java.util.ArrayList<java.lang.Integer>(other.testList);
      this.testList = __this__testList;
    }
    if (other.isSetTestStringSetTypedef()) {
      java.util.Set<java.lang.String> __this__testStringSetTypedef =
          new java.util.HashSet<java.lang.String>(other.testStringSetTypedef);
      this.testStringSetTypedef = __this__testStringSetTypedef;
    }
    if (other.isSetTestEnum()) {
      this.testEnum = other.testEnum;
    }
    if (other.isSetTestNested()) {
      this.testNested = new TestThriftInnerStruct(other.testNested);
    }
    if (other.isSetTestUnion()) {
      this.testUnion = new TestThriftUnion(other.testUnion);
    }
  }

  public TestThriftStruct deepCopy() {
    return new TestThriftStruct(this);
  }

  @Override
  public void clear() {
    setTestByteIsSet(false);
    this.testByte = 0;
    setTestShortIsSet(false);
    this.testShort = 0;
    setTestIntIsSet(false);
    this.testInt = 0;
    setTestLongIsSet(false);
    this.testLong = 0;
    setTestDoubleIsSet(false);
    this.testDouble = 0.0;
    this.stringIntMap = null;
    this.testBinary = null;
    setTestBoolIsSet(false);
    this.testBool = false;
    this.testList = null;
    this.testStringSetTypedef = null;
    this.testEnum = null;
    this.testNested = null;
    this.testUnion = null;
  }

  public byte getTestByte() {
    return this.testByte;
  }

  public void setTestByte(byte testByte) {
    this.testByte = testByte;
    setTestByteIsSet(true);
  }

  public void unsetTestByte() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTBYTE_ISSET_ID);
  }

  /** Returns true if field testByte is set (has been assigned a value) and false otherwise */
  public boolean isSetTestByte() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTBYTE_ISSET_ID);
  }

  public void setTestByteIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTBYTE_ISSET_ID, value);
  }

  public short getTestShort() {
    return this.testShort;
  }

  public void setTestShort(short testShort) {
    this.testShort = testShort;
    setTestShortIsSet(true);
  }

  public void unsetTestShort() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTSHORT_ISSET_ID);
  }

  /** Returns true if field testShort is set (has been assigned a value) and false otherwise */
  public boolean isSetTestShort() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTSHORT_ISSET_ID);
  }

  public void setTestShortIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTSHORT_ISSET_ID, value);
  }

  public int getTestInt() {
    return this.testInt;
  }

  public void setTestInt(int testInt) {
    this.testInt = testInt;
    setTestIntIsSet(true);
  }

  public void unsetTestInt() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTINT_ISSET_ID);
  }

  /** Returns true if field testInt is set (has been assigned a value) and false otherwise */
  public boolean isSetTestInt() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTINT_ISSET_ID);
  }

  public void setTestIntIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTINT_ISSET_ID, value);
  }

  public long getTestLong() {
    return this.testLong;
  }

  public void setTestLong(long testLong) {
    this.testLong = testLong;
    setTestLongIsSet(true);
  }

  public void unsetTestLong() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTLONG_ISSET_ID);
  }

  /** Returns true if field testLong is set (has been assigned a value) and false otherwise */
  public boolean isSetTestLong() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTLONG_ISSET_ID);
  }

  public void setTestLongIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTLONG_ISSET_ID, value);
  }

  public double getTestDouble() {
    return this.testDouble;
  }

  public void setTestDouble(double testDouble) {
    this.testDouble = testDouble;
    setTestDoubleIsSet(true);
  }

  public void unsetTestDouble() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTDOUBLE_ISSET_ID);
  }

  /** Returns true if field testDouble is set (has been assigned a value) and false otherwise */
  public boolean isSetTestDouble() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTDOUBLE_ISSET_ID);
  }

  public void setTestDoubleIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTDOUBLE_ISSET_ID, value);
  }

  public int getStringIntMapSize() {
    return (this.stringIntMap == null) ? 0 : this.stringIntMap.size();
  }

  public void putToStringIntMap(java.lang.String key, short val) {
    if (this.stringIntMap == null) {
      this.stringIntMap = new java.util.HashMap<java.lang.String, java.lang.Short>();
    }
    this.stringIntMap.put(key, val);
  }

  @org.apache.thrift.annotation.Nullable
  public java.util.Map<java.lang.String, java.lang.Short> getStringIntMap() {
    return this.stringIntMap;
  }

  public void setStringIntMap(
      @org.apache.thrift.annotation.Nullable
          java.util.Map<java.lang.String, java.lang.Short> stringIntMap) {
    this.stringIntMap = stringIntMap;
  }

  public void unsetStringIntMap() {
    this.stringIntMap = null;
  }

  /** Returns true if field stringIntMap is set (has been assigned a value) and false otherwise */
  public boolean isSetStringIntMap() {
    return this.stringIntMap != null;
  }

  public void setStringIntMapIsSet(boolean value) {
    if (!value) {
      this.stringIntMap = null;
    }
  }

  public byte[] getTestBinary() {
    setTestBinary(org.apache.thrift.TBaseHelper.rightSize(testBinary));
    return testBinary == null ? null : testBinary.array();
  }

  public java.nio.ByteBuffer bufferForTestBinary() {
    return org.apache.thrift.TBaseHelper.copyBinary(testBinary);
  }

  public void setTestBinary(byte[] testBinary) {
    this.testBinary =
        testBinary == null
            ? (java.nio.ByteBuffer) null
            : java.nio.ByteBuffer.wrap(testBinary.clone());
  }

  public void setTestBinary(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer testBinary) {
    this.testBinary = org.apache.thrift.TBaseHelper.copyBinary(testBinary);
  }

  public void unsetTestBinary() {
    this.testBinary = null;
  }

  /** Returns true if field testBinary is set (has been assigned a value) and false otherwise */
  public boolean isSetTestBinary() {
    return this.testBinary != null;
  }

  public void setTestBinaryIsSet(boolean value) {
    if (!value) {
      this.testBinary = null;
    }
  }

  public boolean isTestBool() {
    return this.testBool;
  }

  public void setTestBool(boolean testBool) {
    this.testBool = testBool;
    setTestBoolIsSet(true);
  }

  public void unsetTestBool() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTBOOL_ISSET_ID);
  }

  /** Returns true if field testBool is set (has been assigned a value) and false otherwise */
  public boolean isSetTestBool() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTBOOL_ISSET_ID);
  }

  public void setTestBoolIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTBOOL_ISSET_ID, value);
  }

  public int getTestListSize() {
    return (this.testList == null) ? 0 : this.testList.size();
  }

  @org.apache.thrift.annotation.Nullable
  public java.util.Iterator<java.lang.Integer> getTestListIterator() {
    return (this.testList == null) ? null : this.testList.iterator();
  }

  public void addToTestList(int elem) {
    if (this.testList == null) {
      this.testList = new java.util.ArrayList<java.lang.Integer>();
    }
    this.testList.add(elem);
  }

  @org.apache.thrift.annotation.Nullable
  public java.util.List<java.lang.Integer> getTestList() {
    return this.testList;
  }

  public void setTestList(
      @org.apache.thrift.annotation.Nullable java.util.List<java.lang.Integer> testList) {
    this.testList = testList;
  }

  public void unsetTestList() {
    this.testList = null;
  }

  /** Returns true if field testList is set (has been assigned a value) and false otherwise */
  public boolean isSetTestList() {
    return this.testList != null;
  }

  public void setTestListIsSet(boolean value) {
    if (!value) {
      this.testList = null;
    }
  }

  public int getTestStringSetTypedefSize() {
    return (this.testStringSetTypedef == null) ? 0 : this.testStringSetTypedef.size();
  }

  @org.apache.thrift.annotation.Nullable
  public java.util.Iterator<java.lang.String> getTestStringSetTypedefIterator() {
    return (this.testStringSetTypedef == null) ? null : this.testStringSetTypedef.iterator();
  }

  public void addToTestStringSetTypedef(java.lang.String elem) {
    if (this.testStringSetTypedef == null) {
      this.testStringSetTypedef = new java.util.HashSet<java.lang.String>();
    }
    this.testStringSetTypedef.add(elem);
  }

  @org.apache.thrift.annotation.Nullable
  public java.util.Set<java.lang.String> getTestStringSetTypedef() {
    return this.testStringSetTypedef;
  }

  public void setTestStringSetTypedef(
      @org.apache.thrift.annotation.Nullable java.util.Set<java.lang.String> testStringSetTypedef) {
    this.testStringSetTypedef = testStringSetTypedef;
  }

  public void unsetTestStringSetTypedef() {
    this.testStringSetTypedef = null;
  }

  /**
   * Returns true if field testStringSetTypedef is set (has been assigned a value) and false
   * otherwise
   */
  public boolean isSetTestStringSetTypedef() {
    return this.testStringSetTypedef != null;
  }

  public void setTestStringSetTypedefIsSet(boolean value) {
    if (!value) {
      this.testStringSetTypedef = null;
    }
  }

  /** @see TestThriftEnum */
  @org.apache.thrift.annotation.Nullable
  public TestThriftEnum getTestEnum() {
    return this.testEnum;
  }

  /** @see TestThriftEnum */
  public void setTestEnum(@org.apache.thrift.annotation.Nullable TestThriftEnum testEnum) {
    this.testEnum = testEnum;
  }

  public void unsetTestEnum() {
    this.testEnum = null;
  }

  /** Returns true if field testEnum is set (has been assigned a value) and false otherwise */
  public boolean isSetTestEnum() {
    return this.testEnum != null;
  }

  public void setTestEnumIsSet(boolean value) {
    if (!value) {
      this.testEnum = null;
    }
  }

  @org.apache.thrift.annotation.Nullable
  public TestThriftInnerStruct getTestNested() {
    return this.testNested;
  }

  public void setTestNested(
      @org.apache.thrift.annotation.Nullable TestThriftInnerStruct testNested) {
    this.testNested = testNested;
  }

  public void unsetTestNested() {
    this.testNested = null;
  }

  /** Returns true if field testNested is set (has been assigned a value) and false otherwise */
  public boolean isSetTestNested() {
    return this.testNested != null;
  }

  public void setTestNestedIsSet(boolean value) {
    if (!value) {
      this.testNested = null;
    }
  }

  @org.apache.thrift.annotation.Nullable
  public TestThriftUnion getTestUnion() {
    return this.testUnion;
  }

  public void setTestUnion(@org.apache.thrift.annotation.Nullable TestThriftUnion testUnion) {
    this.testUnion = testUnion;
  }

  public void unsetTestUnion() {
    this.testUnion = null;
  }

  /** Returns true if field testUnion is set (has been assigned a value) and false otherwise */
  public boolean isSetTestUnion() {
    return this.testUnion != null;
  }

  public void setTestUnionIsSet(boolean value) {
    if (!value) {
      this.testUnion = null;
    }
  }

  public void setFieldValue(
      _Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
    switch (field) {
      case TEST_BYTE:
        if (value == null) {
          unsetTestByte();
        } else {
          setTestByte((java.lang.Byte) value);
        }
        break;

      case TEST_SHORT:
        if (value == null) {
          unsetTestShort();
        } else {
          setTestShort((java.lang.Short) value);
        }
        break;

      case TEST_INT:
        if (value == null) {
          unsetTestInt();
        } else {
          setTestInt((java.lang.Integer) value);
        }
        break;

      case TEST_LONG:
        if (value == null) {
          unsetTestLong();
        } else {
          setTestLong((java.lang.Long) value);
        }
        break;

      case TEST_DOUBLE:
        if (value == null) {
          unsetTestDouble();
        } else {
          setTestDouble((java.lang.Double) value);
        }
        break;

      case STRING_INT_MAP:
        if (value == null) {
          unsetStringIntMap();
        } else {
          setStringIntMap((java.util.Map<java.lang.String, java.lang.Short>) value);
        }
        break;

      case TEST_BINARY:
        if (value == null) {
          unsetTestBinary();
        } else {
          if (value instanceof byte[]) {
            setTestBinary((byte[]) value);
          } else {
            setTestBinary((java.nio.ByteBuffer) value);
          }
        }
        break;

      case TEST_BOOL:
        if (value == null) {
          unsetTestBool();
        } else {
          setTestBool((java.lang.Boolean) value);
        }
        break;

      case TEST_LIST:
        if (value == null) {
          unsetTestList();
        } else {
          setTestList((java.util.List<java.lang.Integer>) value);
        }
        break;

      case TEST_STRING_SET_TYPEDEF:
        if (value == null) {
          unsetTestStringSetTypedef();
        } else {
          setTestStringSetTypedef((java.util.Set<java.lang.String>) value);
        }
        break;

      case TEST_ENUM:
        if (value == null) {
          unsetTestEnum();
        } else {
          setTestEnum((TestThriftEnum) value);
        }
        break;

      case TEST_NESTED:
        if (value == null) {
          unsetTestNested();
        } else {
          setTestNested((TestThriftInnerStruct) value);
        }
        break;

      case TEST_UNION:
        if (value == null) {
          unsetTestUnion();
        } else {
          setTestUnion((TestThriftUnion) value);
        }
        break;
    }
  }

  @org.apache.thrift.annotation.Nullable
  public java.lang.Object getFieldValue(_Fields field) {
    switch (field) {
      case TEST_BYTE:
        return getTestByte();

      case TEST_SHORT:
        return getTestShort();

      case TEST_INT:
        return getTestInt();

      case TEST_LONG:
        return getTestLong();

      case TEST_DOUBLE:
        return getTestDouble();

      case STRING_INT_MAP:
        return getStringIntMap();

      case TEST_BINARY:
        return getTestBinary();

      case TEST_BOOL:
        return isTestBool();

      case TEST_LIST:
        return getTestList();

      case TEST_STRING_SET_TYPEDEF:
        return getTestStringSetTypedef();

      case TEST_ENUM:
        return getTestEnum();

      case TEST_NESTED:
        return getTestNested();

      case TEST_UNION:
        return getTestUnion();
    }
    throw new java.lang.IllegalStateException();
  }

  /**
   * Returns true if field corresponding to fieldID is set (has been assigned a value) and false
   * otherwise
   */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new java.lang.IllegalArgumentException();
    }

    switch (field) {
      case TEST_BYTE:
        return isSetTestByte();
      case TEST_SHORT:
        return isSetTestShort();
      case TEST_INT:
        return isSetTestInt();
      case TEST_LONG:
        return isSetTestLong();
      case TEST_DOUBLE:
        return isSetTestDouble();
      case STRING_INT_MAP:
        return isSetStringIntMap();
      case TEST_BINARY:
        return isSetTestBinary();
      case TEST_BOOL:
        return isSetTestBool();
      case TEST_LIST:
        return isSetTestList();
      case TEST_STRING_SET_TYPEDEF:
        return isSetTestStringSetTypedef();
      case TEST_ENUM:
        return isSetTestEnum();
      case TEST_NESTED:
        return isSetTestNested();
      case TEST_UNION:
        return isSetTestUnion();
    }
    throw new java.lang.IllegalStateException();
  }

  @Override
  public boolean equals(java.lang.Object that) {
    if (that == null) return false;
    if (that instanceof TestThriftStruct) return this.equals((TestThriftStruct) that);
    return false;
  }

  public boolean equals(TestThriftStruct that) {
    if (that == null) return false;
    if (this == that) return true;

    boolean this_present_testByte = true;
    boolean that_present_testByte = true;
    if (this_present_testByte || that_present_testByte) {
      if (!(this_present_testByte && that_present_testByte)) return false;
      if (this.testByte != that.testByte) return false;
    }

    boolean this_present_testShort = true;
    boolean that_present_testShort = true;
    if (this_present_testShort || that_present_testShort) {
      if (!(this_present_testShort && that_present_testShort)) return false;
      if (this.testShort != that.testShort) return false;
    }

    boolean this_present_testInt = true;
    boolean that_present_testInt = true;
    if (this_present_testInt || that_present_testInt) {
      if (!(this_present_testInt && that_present_testInt)) return false;
      if (this.testInt != that.testInt) return false;
    }

    boolean this_present_testLong = true;
    boolean that_present_testLong = true;
    if (this_present_testLong || that_present_testLong) {
      if (!(this_present_testLong && that_present_testLong)) return false;
      if (this.testLong != that.testLong) return false;
    }

    boolean this_present_testDouble = true;
    boolean that_present_testDouble = true;
    if (this_present_testDouble || that_present_testDouble) {
      if (!(this_present_testDouble && that_present_testDouble)) return false;
      if (this.testDouble != that.testDouble) return false;
    }

    boolean this_present_stringIntMap = true && this.isSetStringIntMap();
    boolean that_present_stringIntMap = true && that.isSetStringIntMap();
    if (this_present_stringIntMap || that_present_stringIntMap) {
      if (!(this_present_stringIntMap && that_present_stringIntMap)) return false;
      if (!this.stringIntMap.equals(that.stringIntMap)) return false;
    }

    boolean this_present_testBinary = true && this.isSetTestBinary();
    boolean that_present_testBinary = true && that.isSetTestBinary();
    if (this_present_testBinary || that_present_testBinary) {
      if (!(this_present_testBinary && that_present_testBinary)) return false;
      if (!this.testBinary.equals(that.testBinary)) return false;
    }

    boolean this_present_testBool = true;
    boolean that_present_testBool = true;
    if (this_present_testBool || that_present_testBool) {
      if (!(this_present_testBool && that_present_testBool)) return false;
      if (this.testBool != that.testBool) return false;
    }

    boolean this_present_testList = true && this.isSetTestList();
    boolean that_present_testList = true && that.isSetTestList();
    if (this_present_testList || that_present_testList) {
      if (!(this_present_testList && that_present_testList)) return false;
      if (!this.testList.equals(that.testList)) return false;
    }

    boolean this_present_testStringSetTypedef = true && this.isSetTestStringSetTypedef();
    boolean that_present_testStringSetTypedef = true && that.isSetTestStringSetTypedef();
    if (this_present_testStringSetTypedef || that_present_testStringSetTypedef) {
      if (!(this_present_testStringSetTypedef && that_present_testStringSetTypedef)) return false;
      if (!this.testStringSetTypedef.equals(that.testStringSetTypedef)) return false;
    }

    boolean this_present_testEnum = true && this.isSetTestEnum();
    boolean that_present_testEnum = true && that.isSetTestEnum();
    if (this_present_testEnum || that_present_testEnum) {
      if (!(this_present_testEnum && that_present_testEnum)) return false;
      if (!this.testEnum.equals(that.testEnum)) return false;
    }

    boolean this_present_testNested = true && this.isSetTestNested();
    boolean that_present_testNested = true && that.isSetTestNested();
    if (this_present_testNested || that_present_testNested) {
      if (!(this_present_testNested && that_present_testNested)) return false;
      if (!this.testNested.equals(that.testNested)) return false;
    }

    boolean this_present_testUnion = true && this.isSetTestUnion();
    boolean that_present_testUnion = true && that.isSetTestUnion();
    if (this_present_testUnion || that_present_testUnion) {
      if (!(this_present_testUnion && that_present_testUnion)) return false;
      if (!this.testUnion.equals(that.testUnion)) return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 1;

    hashCode = hashCode * 8191 + (int) (testByte);

    hashCode = hashCode * 8191 + testShort;

    hashCode = hashCode * 8191 + testInt;

    hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(testLong);

    hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(testDouble);

    hashCode = hashCode * 8191 + ((isSetStringIntMap()) ? 131071 : 524287);
    if (isSetStringIntMap()) hashCode = hashCode * 8191 + stringIntMap.hashCode();

    hashCode = hashCode * 8191 + ((isSetTestBinary()) ? 131071 : 524287);
    if (isSetTestBinary()) hashCode = hashCode * 8191 + testBinary.hashCode();

    hashCode = hashCode * 8191 + ((testBool) ? 131071 : 524287);

    hashCode = hashCode * 8191 + ((isSetTestList()) ? 131071 : 524287);
    if (isSetTestList()) hashCode = hashCode * 8191 + testList.hashCode();

    hashCode = hashCode * 8191 + ((isSetTestStringSetTypedef()) ? 131071 : 524287);
    if (isSetTestStringSetTypedef()) hashCode = hashCode * 8191 + testStringSetTypedef.hashCode();

    hashCode = hashCode * 8191 + ((isSetTestEnum()) ? 131071 : 524287);
    if (isSetTestEnum()) hashCode = hashCode * 8191 + testEnum.getValue();

    hashCode = hashCode * 8191 + ((isSetTestNested()) ? 131071 : 524287);
    if (isSetTestNested()) hashCode = hashCode * 8191 + testNested.hashCode();

    hashCode = hashCode * 8191 + ((isSetTestUnion()) ? 131071 : 524287);
    if (isSetTestUnion()) hashCode = hashCode * 8191 + testUnion.hashCode();

    return hashCode;
  }

  @Override
  public int compareTo(TestThriftStruct other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;

    lastComparison = java.lang.Boolean.valueOf(isSetTestByte()).compareTo(other.isSetTestByte());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestByte()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testByte, other.testByte);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestShort()).compareTo(other.isSetTestShort());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestShort()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testShort, other.testShort);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestInt()).compareTo(other.isSetTestInt());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestInt()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testInt, other.testInt);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestLong()).compareTo(other.isSetTestLong());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestLong()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testLong, other.testLong);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison =
        java.lang.Boolean.valueOf(isSetTestDouble()).compareTo(other.isSetTestDouble());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestDouble()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testDouble, other.testDouble);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison =
        java.lang.Boolean.valueOf(isSetStringIntMap()).compareTo(other.isSetStringIntMap());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStringIntMap()) {
      lastComparison =
          org.apache.thrift.TBaseHelper.compareTo(this.stringIntMap, other.stringIntMap);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison =
        java.lang.Boolean.valueOf(isSetTestBinary()).compareTo(other.isSetTestBinary());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestBinary()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testBinary, other.testBinary);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestBool()).compareTo(other.isSetTestBool());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestBool()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testBool, other.testBool);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestList()).compareTo(other.isSetTestList());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestList()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testList, other.testList);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison =
        java.lang.Boolean.valueOf(isSetTestStringSetTypedef())
            .compareTo(other.isSetTestStringSetTypedef());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestStringSetTypedef()) {
      lastComparison =
          org.apache.thrift.TBaseHelper.compareTo(
              this.testStringSetTypedef, other.testStringSetTypedef);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestEnum()).compareTo(other.isSetTestEnum());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestEnum()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testEnum, other.testEnum);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison =
        java.lang.Boolean.valueOf(isSetTestNested()).compareTo(other.isSetTestNested());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestNested()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testNested, other.testNested);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestUnion()).compareTo(other.isSetTestUnion());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestUnion()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testUnion, other.testUnion);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  @org.apache.thrift.annotation.Nullable
  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }

  public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
    scheme(iprot).read(iprot, this);
  }

  public void write(org.apache.thrift.protocol.TProtocol oprot)
      throws org.apache.thrift.TException {
    scheme(oprot).write(oprot, this);
  }

  @Override
  public java.lang.String toString() {
    java.lang.StringBuilder sb = new java.lang.StringBuilder("TestThriftStruct(");
    boolean first = true;

    sb.append("testByte:");
    sb.append(this.testByte);
    first = false;
    if (!first) sb.append(", ");
    sb.append("testShort:");
    sb.append(this.testShort);
    first = false;
    if (!first) sb.append(", ");
    sb.append("testInt:");
    sb.append(this.testInt);
    first = false;
    if (!first) sb.append(", ");
    sb.append("testLong:");
    sb.append(this.testLong);
    first = false;
    if (!first) sb.append(", ");
    sb.append("testDouble:");
    sb.append(this.testDouble);
    first = false;
    if (!first) sb.append(", ");
    sb.append("stringIntMap:");
    if (this.stringIntMap == null) {
      sb.append("null");
    } else {
      sb.append(this.stringIntMap);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("testBinary:");
    if (this.testBinary == null) {
      sb.append("null");
    } else {
      org.apache.thrift.TBaseHelper.toString(this.testBinary, sb);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("testBool:");
    sb.append(this.testBool);
    first = false;
    if (!first) sb.append(", ");
    sb.append("testList:");
    if (this.testList == null) {
      sb.append("null");
    } else {
      sb.append(this.testList);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("testStringSetTypedef:");
    if (this.testStringSetTypedef == null) {
      sb.append("null");
    } else {
      sb.append(this.testStringSetTypedef);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("testEnum:");
    if (this.testEnum == null) {
      sb.append("null");
    } else {
      sb.append(this.testEnum);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("testNested:");
    if (this.testNested == null) {
      sb.append("null");
    } else {
      sb.append(this.testNested);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("testUnion:");
    if (this.testUnion == null) {
      sb.append("null");
    } else {
      sb.append(this.testUnion);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    // check for sub-struct validity
    if (testNested != null) {
      testNested.validate();
    }
  }

  private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    try {
      write(
          new org.apache.thrift.protocol.TCompactProtocol(
              new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in)
      throws java.io.IOException, java.lang.ClassNotFoundException {
    try {
      // it doesn't seem like you should have to do this, but java serialization is wacky, and
      // doesn't call the default constructor.
      __isset_bitfield = 0;
      read(
          new org.apache.thrift.protocol.TCompactProtocol(
              new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class TestThriftStructStandardSchemeFactory
      implements org.apache.thrift.scheme.SchemeFactory {
    public TestThriftStructStandardScheme getScheme() {
      return new TestThriftStructStandardScheme();
    }
  }

  private static class TestThriftStructStandardScheme
      extends org.apache.thrift.scheme.StandardScheme<TestThriftStruct> {

    public void read(org.apache.thrift.protocol.TProtocol iprot, TestThriftStruct struct)
        throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      iprot.readStructBegin();
      while (true) {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (schemeField.id) {
          case 1: // TEST_BYTE
            if (schemeField.type == org.apache.thrift.protocol.TType.BYTE) {
              struct.testByte = iprot.readByte();
              struct.setTestByteIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 2: // TEST_SHORT
            if (schemeField.type == org.apache.thrift.protocol.TType.I16) {
              struct.testShort = iprot.readI16();
              struct.setTestShortIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 3: // TEST_INT
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.testInt = iprot.readI32();
              struct.setTestIntIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 4: // TEST_LONG
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.testLong = iprot.readI64();
              struct.setTestLongIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 5: // TEST_DOUBLE
            if (schemeField.type == org.apache.thrift.protocol.TType.DOUBLE) {
              struct.testDouble = iprot.readDouble();
              struct.setTestDoubleIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 6: // STRING_INT_MAP
            if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
              {
                org.apache.thrift.protocol.TMap _map0 = iprot.readMapBegin();
                struct.stringIntMap =
                    new java.util.HashMap<java.lang.String, java.lang.Short>(2 * _map0.size);
                @org.apache.thrift.annotation.Nullable java.lang.String _key1;
                short _val2;
                for (int _i3 = 0; _i3 < _map0.size; ++_i3) {
                  _key1 = iprot.readString();
                  _val2 = iprot.readI16();
                  struct.stringIntMap.put(_key1, _val2);
                }
                iprot.readMapEnd();
              }
              struct.setStringIntMapIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 7: // TEST_BINARY
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.testBinary = iprot.readBinary();
              struct.setTestBinaryIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 8: // TEST_BOOL
            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
              struct.testBool = iprot.readBool();
              struct.setTestBoolIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 9: // TEST_LIST
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list4 = iprot.readListBegin();
                struct.testList = new java.util.ArrayList<java.lang.Integer>(_list4.size);
                int _elem5;
                for (int _i6 = 0; _i6 < _list4.size; ++_i6) {
                  _elem5 = iprot.readI32();
                  struct.testList.add(_elem5);
                }
                iprot.readListEnd();
              }
              struct.setTestListIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 10: // TEST_STRING_SET_TYPEDEF
            if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
              {
                org.apache.thrift.protocol.TSet _set7 = iprot.readSetBegin();
                struct.testStringSetTypedef =
                    new java.util.HashSet<java.lang.String>(2 * _set7.size);
                @org.apache.thrift.annotation.Nullable java.lang.String _elem8;
                for (int _i9 = 0; _i9 < _set7.size; ++_i9) {
                  _elem8 = iprot.readString();
                  struct.testStringSetTypedef.add(_elem8);
                }
                iprot.readSetEnd();
              }
              struct.setTestStringSetTypedefIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 11: // TEST_ENUM
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.testEnum =
                  org.apache.beam.sdk.io.thrift.TestThriftEnum.findByValue(iprot.readI32());
              struct.setTestEnumIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 12: // TEST_NESTED
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.testNested = new TestThriftInnerStruct();
              struct.testNested.read(iprot);
              struct.setTestNestedIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 13: // TEST_UNION
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.testUnion = new TestThriftUnion();
              struct.testUnion.read(iprot);
              struct.setTestUnionIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
      struct.validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot, TestThriftStruct struct)
        throws org.apache.thrift.TException {
      struct.validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldBegin(TEST_BYTE_FIELD_DESC);
      oprot.writeByte(struct.testByte);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(TEST_SHORT_FIELD_DESC);
      oprot.writeI16(struct.testShort);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(TEST_INT_FIELD_DESC);
      oprot.writeI32(struct.testInt);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(TEST_LONG_FIELD_DESC);
      oprot.writeI64(struct.testLong);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(TEST_DOUBLE_FIELD_DESC);
      oprot.writeDouble(struct.testDouble);
      oprot.writeFieldEnd();
      if (struct.stringIntMap != null) {
        oprot.writeFieldBegin(STRING_INT_MAP_FIELD_DESC);
        {
          oprot.writeMapBegin(
              new org.apache.thrift.protocol.TMap(
                  org.apache.thrift.protocol.TType.STRING,
                  org.apache.thrift.protocol.TType.I16,
                  struct.stringIntMap.size()));
          for (java.util.Map.Entry<java.lang.String, java.lang.Short> _iter10 :
              struct.stringIntMap.entrySet()) {
            oprot.writeString(_iter10.getKey());
            oprot.writeI16(_iter10.getValue());
          }
          oprot.writeMapEnd();
        }
        oprot.writeFieldEnd();
      }
      if (struct.testBinary != null) {
        oprot.writeFieldBegin(TEST_BINARY_FIELD_DESC);
        oprot.writeBinary(struct.testBinary);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldBegin(TEST_BOOL_FIELD_DESC);
      oprot.writeBool(struct.testBool);
      oprot.writeFieldEnd();
      if (struct.testList != null) {
        oprot.writeFieldBegin(TEST_LIST_FIELD_DESC);
        {
          oprot.writeListBegin(
              new org.apache.thrift.protocol.TList(
                  org.apache.thrift.protocol.TType.I32, struct.testList.size()));
          for (int _iter11 : struct.testList) {
            oprot.writeI32(_iter11);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      if (struct.testStringSetTypedef != null) {
        oprot.writeFieldBegin(TEST_STRING_SET_TYPEDEF_FIELD_DESC);
        {
          oprot.writeSetBegin(
              new org.apache.thrift.protocol.TSet(
                  org.apache.thrift.protocol.TType.STRING, struct.testStringSetTypedef.size()));
          for (java.lang.String _iter12 : struct.testStringSetTypedef) {
            oprot.writeString(_iter12);
          }
          oprot.writeSetEnd();
        }
        oprot.writeFieldEnd();
      }
      if (struct.testEnum != null) {
        oprot.writeFieldBegin(TEST_ENUM_FIELD_DESC);
        oprot.writeI32(struct.testEnum.getValue());
        oprot.writeFieldEnd();
      }
      if (struct.testNested != null) {
        oprot.writeFieldBegin(TEST_NESTED_FIELD_DESC);
        struct.testNested.write(oprot);
        oprot.writeFieldEnd();
      }
      if (struct.testUnion != null) {
        oprot.writeFieldBegin(TEST_UNION_FIELD_DESC);
        struct.testUnion.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }
  }

  private static class TestThriftStructTupleSchemeFactory
      implements org.apache.thrift.scheme.SchemeFactory {
    public TestThriftStructTupleScheme getScheme() {
      return new TestThriftStructTupleScheme();
    }
  }

  private static class TestThriftStructTupleScheme
      extends org.apache.thrift.scheme.TupleScheme<TestThriftStruct> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, TestThriftStruct struct)
        throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TTupleProtocol oprot =
          (org.apache.thrift.protocol.TTupleProtocol) prot;
      java.util.BitSet optionals = new java.util.BitSet();
      if (struct.isSetTestByte()) {
        optionals.set(0);
      }
      if (struct.isSetTestShort()) {
        optionals.set(1);
      }
      if (struct.isSetTestInt()) {
        optionals.set(2);
      }
      if (struct.isSetTestLong()) {
        optionals.set(3);
      }
      if (struct.isSetTestDouble()) {
        optionals.set(4);
      }
      if (struct.isSetStringIntMap()) {
        optionals.set(5);
      }
      if (struct.isSetTestBinary()) {
        optionals.set(6);
      }
      if (struct.isSetTestBool()) {
        optionals.set(7);
      }
      if (struct.isSetTestList()) {
        optionals.set(8);
      }
      if (struct.isSetTestStringSetTypedef()) {
        optionals.set(9);
      }
      if (struct.isSetTestEnum()) {
        optionals.set(10);
      }
      if (struct.isSetTestNested()) {
        optionals.set(11);
      }
      if (struct.isSetTestUnion()) {
        optionals.set(12);
      }
      oprot.writeBitSet(optionals, 13);
      if (struct.isSetTestByte()) {
        oprot.writeByte(struct.testByte);
      }
      if (struct.isSetTestShort()) {
        oprot.writeI16(struct.testShort);
      }
      if (struct.isSetTestInt()) {
        oprot.writeI32(struct.testInt);
      }
      if (struct.isSetTestLong()) {
        oprot.writeI64(struct.testLong);
      }
      if (struct.isSetTestDouble()) {
        oprot.writeDouble(struct.testDouble);
      }
      if (struct.isSetStringIntMap()) {
        {
          oprot.writeI32(struct.stringIntMap.size());
          for (java.util.Map.Entry<java.lang.String, java.lang.Short> _iter13 :
              struct.stringIntMap.entrySet()) {
            oprot.writeString(_iter13.getKey());
            oprot.writeI16(_iter13.getValue());
          }
        }
      }
      if (struct.isSetTestBinary()) {
        oprot.writeBinary(struct.testBinary);
      }
      if (struct.isSetTestBool()) {
        oprot.writeBool(struct.testBool);
      }
      if (struct.isSetTestList()) {
        {
          oprot.writeI32(struct.testList.size());
          for (int _iter14 : struct.testList) {
            oprot.writeI32(_iter14);
          }
        }
      }
      if (struct.isSetTestStringSetTypedef()) {
        {
          oprot.writeI32(struct.testStringSetTypedef.size());
          for (java.lang.String _iter15 : struct.testStringSetTypedef) {
            oprot.writeString(_iter15);
          }
        }
      }
      if (struct.isSetTestEnum()) {
        oprot.writeI32(struct.testEnum.getValue());
      }
      if (struct.isSetTestNested()) {
        struct.testNested.write(oprot);
      }
      if (struct.isSetTestUnion()) {
        struct.testUnion.write(oprot);
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, TestThriftStruct struct)
        throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TTupleProtocol iprot =
          (org.apache.thrift.protocol.TTupleProtocol) prot;
      java.util.BitSet incoming = iprot.readBitSet(13);
      if (incoming.get(0)) {
        struct.testByte = iprot.readByte();
        struct.setTestByteIsSet(true);
      }
      if (incoming.get(1)) {
        struct.testShort = iprot.readI16();
        struct.setTestShortIsSet(true);
      }
      if (incoming.get(2)) {
        struct.testInt = iprot.readI32();
        struct.setTestIntIsSet(true);
      }
      if (incoming.get(3)) {
        struct.testLong = iprot.readI64();
        struct.setTestLongIsSet(true);
      }
      if (incoming.get(4)) {
        struct.testDouble = iprot.readDouble();
        struct.setTestDoubleIsSet(true);
      }
      if (incoming.get(5)) {
        {
          org.apache.thrift.protocol.TMap _map16 =
              new org.apache.thrift.protocol.TMap(
                  org.apache.thrift.protocol.TType.STRING,
                  org.apache.thrift.protocol.TType.I16,
                  iprot.readI32());
          struct.stringIntMap =
              new java.util.HashMap<java.lang.String, java.lang.Short>(2 * _map16.size);
          @org.apache.thrift.annotation.Nullable java.lang.String _key17;
          short _val18;
          for (int _i19 = 0; _i19 < _map16.size; ++_i19) {
            _key17 = iprot.readString();
            _val18 = iprot.readI16();
            struct.stringIntMap.put(_key17, _val18);
          }
        }
        struct.setStringIntMapIsSet(true);
      }
      if (incoming.get(6)) {
        struct.testBinary = iprot.readBinary();
        struct.setTestBinaryIsSet(true);
      }
      if (incoming.get(7)) {
        struct.testBool = iprot.readBool();
        struct.setTestBoolIsSet(true);
      }
      if (incoming.get(8)) {
        {
          org.apache.thrift.protocol.TList _list20 =
              new org.apache.thrift.protocol.TList(
                  org.apache.thrift.protocol.TType.I32, iprot.readI32());
          struct.testList = new java.util.ArrayList<java.lang.Integer>(_list20.size);
          int _elem21;
          for (int _i22 = 0; _i22 < _list20.size; ++_i22) {
            _elem21 = iprot.readI32();
            struct.testList.add(_elem21);
          }
        }
        struct.setTestListIsSet(true);
      }
      if (incoming.get(9)) {
        {
          org.apache.thrift.protocol.TSet _set23 =
              new org.apache.thrift.protocol.TSet(
                  org.apache.thrift.protocol.TType.STRING, iprot.readI32());
          struct.testStringSetTypedef = new java.util.HashSet<java.lang.String>(2 * _set23.size);
          @org.apache.thrift.annotation.Nullable java.lang.String _elem24;
          for (int _i25 = 0; _i25 < _set23.size; ++_i25) {
            _elem24 = iprot.readString();
            struct.testStringSetTypedef.add(_elem24);
          }
        }
        struct.setTestStringSetTypedefIsSet(true);
      }
      if (incoming.get(10)) {
        struct.testEnum = org.apache.beam.sdk.io.thrift.TestThriftEnum.findByValue(iprot.readI32());
        struct.setTestEnumIsSet(true);
      }
      if (incoming.get(11)) {
        struct.testNested = new TestThriftInnerStruct();
        struct.testNested.read(iprot);
        struct.setTestNestedIsSet(true);
      }
      if (incoming.get(12)) {
        struct.testUnion = new TestThriftUnion();
        struct.testUnion.read(iprot);
        struct.setTestUnionIsSet(true);
      }
    }
  }

  private static <S extends org.apache.thrift.scheme.IScheme> S scheme(
      org.apache.thrift.protocol.TProtocol proto) {
    return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
            ? STANDARD_SCHEME_FACTORY
            : TUPLE_SCHEME_FACTORY)
        .getScheme();
  }
}
