/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.blob.OverflowableBlob;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.ext.io.StreamCopyException;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.DebugInputStream;
import org.apache.axiom.mime.Header;
import org.apache.axiom.mime.MIMEException;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.mime.Part;
import org.apache.axiom.mime.PartInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;

final class PartImpl
implements Part {
    private static final int STATE_UNREAD = 0;
    private static final int STATE_BUFFERED = 1;
    private static final int STATE_STREAMING = 2;
    private static final int STATE_DISCARDED = 3;
    private static final Log log = LogFactory.getLog(PartImpl.class);
    private final MultipartBody message;
    private final WritableBlobFactory<?> blobFactory;
    private final String contentID;
    private final List<Header> headers;
    private ContentType contentType;
    private int state = 0;
    private MimeTokenStream parser;
    private WritableBlob content;
    private DataHandler dataHandler;
    private PartInputStream partInputStream;
    private PartImpl nextPart;

    PartImpl(MultipartBody message, WritableBlobFactory<?> blobFactory, String contentID, List<Header> headers, MimeTokenStream parser) {
        this.message = message;
        this.blobFactory = blobFactory;
        this.contentID = contentID;
        this.headers = headers;
        this.parser = parser;
    }

    @Override
    public String getHeader(String name) {
        String value = null;
        int l = this.headers.size();
        for (int i = 0; i < l; ++i) {
            Header header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            value = header.getValue();
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getHeader name=(" + name + ") value=(" + value + ")"));
        }
        return value;
    }

    @Override
    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    @Override
    public String getContentID() {
        return this.contentID;
    }

    @Override
    public ContentType getContentType() {
        if (this.contentType == null) {
            try {
                this.contentType = new ContentType(this.getHeader("content-type"));
            }
            catch (ParseException ex) {
                throw new MIMEException(ex);
            }
        }
        return this.contentType;
    }

    @Override
    public DataHandler getDataHandler() {
        if (this.dataHandler == null) {
            this.dataHandler = this.message.getDataHandlerFactory().createDataHandler(this);
        }
        return this.dataHandler;
    }

    private WritableBlob getContent() {
        switch (this.state) {
            case 0: {
                this.fetch();
            }
            case 1: {
                return this.content;
            }
        }
        throw new IllegalStateException("The content of the MIME part has already been consumed");
    }

    @Override
    public Blob getBlob() {
        WritableBlob overflowBlob;
        WritableBlob blob = this.getContent();
        if (blob instanceof OverflowableBlob && (overflowBlob = ((OverflowableBlob)blob).getOverflowBlob()) != null) {
            blob = overflowBlob;
        }
        return blob;
    }

    private static void checkParserState(EntityState state, EntityState expected) throws IllegalStateException {
        if (expected != state) {
            throw new IllegalStateException("Internal error: expected parser to be in state " + expected + ", but got " + state);
        }
    }

    private InputStream getDecodedInputStream() {
        InputStream in = this.parser.getDecodedInputStream();
        if (log.isDebugEnabled()) {
            in = new DebugInputStream(in, log);
        }
        return in;
    }

    @Override
    public void fetch() {
        switch (this.state) {
            case 0: {
                PartImpl.checkParserState(this.parser.getState(), EntityState.T_BODY);
                this.content = this.blobFactory.createBlob();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using blob of type " + this.content.getClass().getName()));
                }
                try {
                    this.content.readFrom(this.getDecodedInputStream());
                }
                catch (StreamCopyException ex) {
                    if (ex.getOperation() == 1) {
                        throw new MIMEException("Failed to fetch the MIME part content", ex.getCause());
                    }
                    throw new MIMEException("Failed to write the MIME part content to temporary storage", ex.getCause());
                }
                this.moveToNextPart();
                this.state = 1;
                break;
            }
            case 2: {
                try {
                    this.partInputStream.detach();
                }
                catch (IOException ex) {
                    throw new MIMEException(ex);
                }
                this.partInputStream = null;
                this.moveToNextPart();
                this.state = 3;
            }
        }
    }

    private void moveToNextPart() {
        try {
            PartImpl.checkParserState(this.parser.next(), EntityState.T_END_BODYPART);
            EntityState state = this.parser.next();
            if (state == EntityState.T_EPILOGUE) {
                while (this.parser.next() != EntityState.T_END_MULTIPART) {
                }
            } else if (state != EntityState.T_START_BODYPART && state != EntityState.T_END_MULTIPART) {
                throw new IllegalStateException("Internal error: unexpected parser state " + state);
            }
        }
        catch (IOException ex) {
            throw new MIMEException(ex);
        }
        catch (MimeException ex) {
            throw new MIMEException(ex);
        }
        this.parser = null;
    }

    @Override
    public InputStream getInputStream(boolean preserve) {
        if (!preserve && this.state == 0) {
            PartImpl.checkParserState(this.parser.getState(), EntityState.T_BODY);
            this.state = 2;
            this.partInputStream = new PartInputStream(this.getDecodedInputStream(), this.blobFactory);
            return this.partInputStream;
        }
        WritableBlob content = this.getContent();
        try {
            if (preserve) {
                return content.getInputStream();
            }
            return new PartInputStream(content);
        }
        catch (IOException ex) {
            throw new MIMEException("Failed to retrieve part content from blob", ex);
        }
    }

    @Override
    public void discard() {
        try {
            switch (this.state) {
                case 0: {
                    EntityState parserState;
                    while ((parserState = this.parser.next()) != EntityState.T_START_BODYPART && parserState != EntityState.T_END_MULTIPART) {
                    }
                    this.state = 3;
                    break;
                }
                case 1: {
                    this.content.release();
                }
            }
        }
        catch (MimeException ex) {
            throw new MIMEException(ex);
        }
        catch (IOException ex) {
            throw new MIMEException(ex);
        }
    }

    PartImpl getNextPart() {
        if (this.nextPart == null) {
            this.message.getNextPart();
        }
        return this.nextPart;
    }

    void setNextPart(PartImpl nextPart) {
        this.nextPart = nextPart;
    }
}

