/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dispatchers;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.dispatchers.AbstractOperationDispatcher;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestURIBasedOperationDispatcher
extends AbstractOperationDispatcher {
    public static final String NAME = "RequestURIBasedOperationDispatcher";
    private static final Log log = LogFactory.getLog(RequestURIBasedOperationDispatcher.class);

    @Override
    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            String filePart = toEPR.getAddress();
            String operation = Utils.getOperationName(filePart, service.getName());
            if (operation != null) {
                QName operationName = new QName(operation);
                log.debug((Object)(messageContext.getLogIDString() + " Checking for Operation using QName(target endpoint URI fragment) : " + operationName));
                return service.getOperation(operationName);
            }
            log.debug((Object)(messageContext.getLogIDString() + " Attempted to check for Operation using target endpoint URI, but the operation fragment was missing on filePart: " + filePart + " , service name: " + service.getName()));
            return null;
        }
        log.debug((Object)(messageContext.getLogIDString() + " Attempted to check for Operation using null target endpoint URI"));
        return null;
    }

    @Override
    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

