/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit.listener;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.ant.antunit.listener.BaseAntUnitListener;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;

public class PlainAntUnitListener
extends BaseAntUnitListener {
    private OutputStream out = null;
    private StringWriter inner;
    private PrintWriter wri;
    private StringBuffer log = new StringBuffer();
    private static final String NEW_LINE = System.getProperty("line.separator");

    public PlainAntUnitListener() {
        super(new BaseAntUnitListener.SendLogTo("ant"), "txt");
    }

    public void setSendLogTo(BaseAntUnitListener.SendLogTo logTo) {
        super.setSendLogTo(logTo);
    }

    public void startTestSuite(Project testProject, String buildFile) {
        super.startTestSuite(testProject, buildFile);
        this.inner = new StringWriter();
        this.wri = new PrintWriter(this.inner);
        this.out = this.getOut(buildFile);
        StringBuffer sb = new StringBuffer("Build File: ");
        sb.append(buildFile);
        sb.append(NEW_LINE);
        try {
            this.out.write(sb.toString().getBytes());
            this.out.flush();
        }
        catch (IOException ex) {
            throw new BuildException("Unable to write output", (Throwable)ex);
        }
    }

    public void endTestSuite(Project testProject, String buildFile) {
        long runTime = System.currentTimeMillis() - this.start;
        StringBuffer sb = new StringBuffer("Tests run: ");
        sb.append(this.runCount);
        sb.append(", Failures: ");
        sb.append(this.failureCount);
        sb.append(", Errors: ");
        sb.append(this.errorCount);
        sb.append(", Time elapsed: ");
        sb.append(nf.format((double)runTime / 1000.0));
        sb.append(" sec");
        sb.append(NEW_LINE);
        if (this.log.length() > 0) {
            sb.append("------------- Log Output       ---------------");
            sb.append(NEW_LINE);
            sb.append(this.log.toString());
            this.log.setLength(0);
            sb.append("------------- ---------------- ---------------");
            sb.append(NEW_LINE);
        }
        if (this.out != null) {
            try {
                this.out.write(sb.toString().getBytes());
                this.wri.close();
                this.out.write(this.inner.toString().getBytes());
                this.out.flush();
            }
            catch (IOException ioex) {
                throw new BuildException("Unable to write output", (Throwable)ioex);
            }
            finally {
                this.close(this.out);
            }
        }
    }

    public void startTest(String target) {
        super.startTest(target);
        this.wri.print("Target: " + target + " ");
    }

    public void endTest(String target) {
        double seconds = (double)(System.currentTimeMillis() - this.testStart) / 1000.0;
        this.wri.println("took " + nf.format(seconds) + " sec");
    }

    public void addFailure(String target, AssertionFailedException ae) {
        super.addFailure(target, ae);
        this.formatError(" FAILED", (Throwable)((Object)ae));
    }

    public void addError(String target, Throwable ae) {
        super.addError(target, ae);
        this.formatError(" caused an ERROR", ae);
    }

    private void formatError(String type, Throwable t) {
        this.wri.println(type);
        Location l = this.getLocation(t);
        if (l.getLineNumber() != 0) {
            this.wri.print("\tat line " + l.getLineNumber());
            if (l.getColumnNumber() != 0) {
                this.wri.print(", column " + l.getColumnNumber());
            }
            this.wri.println();
        }
        this.wri.println("\tMessage: " + t.getMessage());
        this.wri.print("\t");
    }

    protected void messageLogged(BuildEvent event) {
        this.log.append(event.getMessage());
        this.log.append(NEW_LINE);
    }
}

