/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf.internal;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.hubspot.jackson.datatype.protobuf.PropertyNamingStrategyWrapper;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;

public class PropertyNamingCache {
    private final Descriptors.Descriptor descriptor;
    private final Class<? extends Message> messageType;
    private final ProtobufJacksonConfig config;
    private final Map<PropertyNamingStrategy, Function<Descriptors.FieldDescriptor, String>> serializationCache;
    private final Map<PropertyNamingStrategy, Function<String, Descriptors.FieldDescriptor>> deserializationCache;

    private PropertyNamingCache(Descriptors.Descriptor descriptor, Class<? extends Message> messageType, ProtobufJacksonConfig config) {
        this.descriptor = descriptor;
        this.messageType = messageType;
        this.config = config;
        this.serializationCache = Collections.synchronizedMap(new WeakHashMap());
        this.deserializationCache = Collections.synchronizedMap(new WeakHashMap());
    }

    public static PropertyNamingCache forDescriptor(Descriptors.Descriptor descriptor, Class<? extends Message> messageType, ProtobufJacksonConfig config) {
        return new PropertyNamingCache(descriptor, messageType, config);
    }

    public Function<Descriptors.FieldDescriptor, String> forSerialization(MapperConfig<?> mapperConfig) {
        Function<Descriptors.FieldDescriptor, String> cached = this.serializationCache.get(mapperConfig.getPropertyNamingStrategy());
        if (cached != null) {
            return cached;
        }
        Function<Descriptors.FieldDescriptor, String> function = this.buildSerializationFunction(this.descriptor, mapperConfig);
        this.serializationCache.put(mapperConfig.getPropertyNamingStrategy(), function);
        return function;
    }

    public Function<String, Descriptors.FieldDescriptor> forDeserialization(MapperConfig<?> mapperConfig) {
        Function<String, Descriptors.FieldDescriptor> cached = this.deserializationCache.get(mapperConfig.getPropertyNamingStrategy());
        if (cached != null) {
            return cached;
        }
        Function<String, Descriptors.FieldDescriptor> function = this.buildDeserializationFunction(this.descriptor, mapperConfig);
        this.deserializationCache.put(mapperConfig.getPropertyNamingStrategy(), function);
        return function;
    }

    private Function<Descriptors.FieldDescriptor, String> buildSerializationFunction(Descriptors.Descriptor descriptor, MapperConfig<?> mapperConfig) {
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(this.messageType, mapperConfig);
        HashMap<Descriptors.FieldDescriptor, String> tempMap = new HashMap<Descriptors.FieldDescriptor, String>();
        for (Descriptors.FieldDescriptor field2 : descriptor.getFields()) {
            tempMap.put(field2, PropertyNamingCache.getFieldName(field2, namingStrategy));
        }
        ImmutableMap fieldLookup = ImmutableMap.copyOf(tempMap);
        return field -> {
            String name = (String)fieldLookup.get(field);
            return name == null ? namingStrategy.translate(field.getName()) : name;
        };
    }

    private Function<String, Descriptors.FieldDescriptor> buildDeserializationFunction(Descriptors.Descriptor descriptor, MapperConfig<?> mapperConfig) {
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(this.messageType, mapperConfig);
        HashMap<String, Descriptors.FieldDescriptor> tempMap = new HashMap<String, Descriptors.FieldDescriptor>();
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            tempMap.put(PropertyNamingCache.getFieldName(field, namingStrategy), field);
        }
        if (this.config.acceptLiteralFieldnames()) {
            for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
                if (tempMap.containsKey(field.getName())) continue;
                tempMap.put(field.getName(), field);
            }
        }
        ImmutableMap fieldLookup = ImmutableMap.copyOf(tempMap);
        return ((Map)fieldLookup)::get;
    }

    private static String getFieldName(Descriptors.FieldDescriptor field, PropertyNamingStrategyWrapper namingStrategy) {
        return PropertyNamingCache.hasJsonName(field) ? field.getJsonName() : namingStrategy.translate(field.getName());
    }

    private static boolean hasJsonName(Descriptors.FieldDescriptor field) {
        if (!field.toProto().hasJsonName()) {
            return false;
        }
        return !field.getJsonName().equals(PropertyNamingCache.defaultJsonName(field.getName()));
    }

    private static String defaultJsonName(String fieldName) {
        int length = fieldName.length();
        StringBuilder result = new StringBuilder(length);
        boolean isNextUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char ch = fieldName.charAt(i);
            if (ch == '_') {
                isNextUpperCase = true;
                continue;
            }
            if (isNextUpperCase) {
                if ('a' <= ch && ch <= 'z') {
                    ch = (char)(ch - 97 + 65);
                }
                result.append(ch);
                isNextUpperCase = false;
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }
}

