/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class JsonAsStringJdbcType
extends JsonJdbcType
implements AdjustableJdbcType {
    public static final JsonAsStringJdbcType VARCHAR_INSTANCE = new JsonAsStringJdbcType(4001, null);
    public static final JsonAsStringJdbcType NVARCHAR_INSTANCE = new JsonAsStringJdbcType(4002, null);
    public static final JsonAsStringJdbcType CLOB_INSTANCE = new JsonAsStringJdbcType(2005, null);
    public static final JsonAsStringJdbcType NCLOB_INSTANCE = new JsonAsStringJdbcType(2011, null);
    private final boolean nationalized;
    private final int ddlTypeCode;

    protected JsonAsStringJdbcType(int ddlTypeCode, EmbeddableMappingType embeddableMappingType) {
        super(embeddableMappingType);
        this.ddlTypeCode = ddlTypeCode;
        this.nationalized = ddlTypeCode == 4002 || ddlTypeCode == 2011;
    }

    @Override
    public int getJdbcTypeCode() {
        return this.nationalized ? -9 : 12;
    }

    @Override
    public int getDdlTypeCode() {
        return this.ddlTypeCode;
    }

    @Override
    public String toString() {
        return "JsonAsStringJdbcType";
    }

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<?> domainJtd) {
        if (this.getEmbeddableMappingType() == null) {
            if (this.needsLob(indicators)) {
                return indicators.isNationalized() ? NCLOB_INSTANCE : CLOB_INSTANCE;
            }
            return indicators.isNationalized() ? NVARCHAR_INSTANCE : VARCHAR_INSTANCE;
        }
        if (this.needsLob(indicators)) {
            return new JsonAsStringJdbcType(indicators.isNationalized() ? 2011 : 2005, this.getEmbeddableMappingType());
        }
        return new JsonAsStringJdbcType(indicators.isNationalized() ? 4002 : 4001, this.getEmbeddableMappingType());
    }

    protected boolean needsLob(JdbcTypeIndicators indicators) {
        long maxLength;
        Dialect dialect = indicators.getTypeConfiguration().getServiceRegistry().getService(JdbcServices.class).getDialect();
        long length = indicators.getColumnLength();
        long l = maxLength = indicators.isNationalized() ? (long)dialect.getMaxNVarcharLength() : (long)dialect.getMaxVarcharLength();
        if (length > maxLength) {
            return true;
        }
        DdlTypeRegistry ddlTypeRegistry = indicators.getTypeConfiguration().getDdlTypeRegistry();
        String typeName = ddlTypeRegistry.getTypeName(this.getDdlTypeCode(), dialect);
        return typeName.equals(ddlTypeRegistry.getTypeName(2005, dialect)) || typeName.equals(ddlTypeRegistry.getTypeName(2011, dialect));
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new JsonAsStringJdbcType(this.ddlTypeCode, mappingType);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        if (this.nationalized) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    String json = ((JsonAsStringJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                    st.setNString(index, json);
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    String json = ((JsonAsStringJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                    st.setNString(name, json);
                }
            };
        }
        return super.getBinder(javaType);
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        if (this.nationalized) {
            return new BasicExtractor<X>(javaType, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    return JsonAsStringJdbcType.this.fromString(rs.getNString(paramIndex), this.getJavaType(), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return JsonAsStringJdbcType.this.fromString(statement.getNString(index), this.getJavaType(), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return JsonAsStringJdbcType.this.fromString(statement.getNString(name), this.getJavaType(), options);
                }
            };
        }
        return super.getExtractor(javaType);
    }
}

