/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.PathException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmEmbeddedValuedSimplePath<T>
extends AbstractSqmSimplePath<T>
implements SqmExpressible<T> {
    public SqmEmbeddedValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, nodeBuilder);
        assert (referencedPathSource.getSqmPathType() instanceof EmbeddableDomainType);
    }

    public SqmEmbeddedValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, String explicitAlias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, explicitAlias, nodeBuilder);
        assert (referencedPathSource.getSqmPathType() instanceof EmbeddableDomainType);
    }

    @Override
    public SqmEmbeddedValuedSimplePath<T> copy(SqmCopyContext context) {
        SqmEmbeddedValuedSimplePath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmExpression lhsCopy = this.getLhs().copy(context);
        SqmEmbeddedValuedSimplePath<T> path = context.registerCopy(this, new SqmEmbeddedValuedSimplePath<T>(this.getNavigablePathCopy((SqmPath<?>)lhsCopy), this.getModel(), (SqmPath<?>)lhsCopy, this.getExplicitAlias(), this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmExpressible<T> getExpressible() {
        return this;
    }

    @Override
    public DomainType<T> getSqmType() {
        return this.getResolvedModel().getSqmType();
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        JpaPath sqmPath = this.get(name);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register((SqmPath<?>)sqmPath);
        return sqmPath;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEmbeddableValuedPath(this);
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> treatJavaType) throws PathException {
        throw new FunctionArgumentException("Embeddable paths cannot be TREAT-ed");
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        throw new FunctionArgumentException("Embeddable paths cannot be TREAT-ed");
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Override
    public Class<T> getJavaType() {
        return this.getJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public Class<T> getBindableJavaType() {
        return this.getJavaType();
    }
}

