/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.spi;

import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;
import org.hibernate.type.descriptor.ValueBinder;

public class Binding {
    private final String columnName;
    private final Object value;
    private final JdbcValueDescriptor valueDescriptor;

    public Binding(String columnName, Object value, JdbcValueDescriptor valueDescriptor) {
        this.columnName = columnName;
        this.value = value;
        this.valueDescriptor = valueDescriptor;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object getValue() {
        return this.value;
    }

    public JdbcValueDescriptor getValueDescriptor() {
        return this.valueDescriptor;
    }

    public <T> ValueBinder<T> getValueBinder() {
        return this.getValueDescriptor().getJdbcMapping().getJdbcValueBinder();
    }

    public int getPosition() {
        return this.getValueDescriptor().getJdbcPosition();
    }

    public int hashCode() {
        return this.getPosition();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding other = (Binding)o;
        return this.getPosition() == other.getPosition();
    }

    public String toString() {
        return "Binding(" + this.columnName + ")";
    }
}

