/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.propertydescriptor;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.dozer.factory.DestBeanCreator;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.AbstractPropertyDescriptor;
import org.dozer.propertydescriptor.DozerPropertyDescriptor;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldPropertyDescriptor
extends AbstractPropertyDescriptor
implements DozerPropertyDescriptor {
    private final DozerPropertyDescriptor[] descriptorChain;

    public FieldPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, int index, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer) {
        super(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        String[] tokens = fieldName.split("\\.");
        this.descriptorChain = new DozerPropertyDescriptor[tokens.length];
        Class<?> currentType = clazz;
        int tokensLength = tokens.length;
        for (int i = 0; i < tokensLength; ++i) {
            String token = tokens[i];
            this.descriptorChain[i] = new ChainedPropertyDescriptor(currentType, token, isIndexed, index);
            if (i >= tokensLength) continue;
            Field field = ReflectionUtils.getFieldFromBean(currentType, tokens[i]);
            currentType = field.getType();
        }
    }

    @Override
    public Class<?> getPropertyType() {
        return this.descriptorChain[this.descriptorChain.length - 1].getPropertyType();
    }

    @Override
    public Class<?> genericType() {
        return this.descriptorChain[this.descriptorChain.length - 1].genericType();
    }

    @Override
    public Object getPropertyValue(Object bean) {
        Object intermediateResult = bean;
        for (DozerPropertyDescriptor descriptor : this.descriptorChain) {
            if ((intermediateResult = descriptor.getPropertyValue(intermediateResult)) != null) continue;
            return null;
        }
        return intermediateResult;
    }

    @Override
    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        Object intermediateResult = bean;
        for (int i = 0; i < this.descriptorChain.length; ++i) {
            DozerPropertyDescriptor descriptor = this.descriptorChain[i];
            if (i != this.descriptorChain.length - 1) {
                Object currentValue = descriptor.getPropertyValue(intermediateResult);
                if (currentValue == null) {
                    currentValue = DestBeanCreator.create(descriptor.getPropertyType());
                    descriptor.setPropertyValue(intermediateResult, currentValue, fieldMap);
                }
                intermediateResult = currentValue;
                continue;
            }
            descriptor.setPropertyValue(intermediateResult, value, fieldMap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChainedPropertyDescriptor
    implements DozerPropertyDescriptor {
        private Field field;
        private boolean indexed;
        private int index;

        ChainedPropertyDescriptor(Class<?> clazz, String fieldName, boolean indexed, int index) {
            this.indexed = indexed;
            this.index = index;
            this.field = ReflectionUtils.getFieldFromBean(clazz, fieldName);
        }

        @Override
        public Class<?> getPropertyType() {
            return this.field.getType();
        }

        @Override
        public Object getPropertyValue(Object bean) {
            Object result = null;
            try {
                result = this.field.get(bean);
            }
            catch (IllegalArgumentException e) {
                MappingUtils.throwMappingException(e);
            }
            catch (IllegalAccessException e) {
                MappingUtils.throwMappingException(e);
            }
            if (this.indexed) {
                result = MappingUtils.getIndexedValue(result, this.index);
            }
            return result;
        }

        @Override
        public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
            if (value == null && this.getPropertyType().isPrimitive()) {
                return;
            }
            if (this.getPropertyValue(bean) == value) {
                return;
            }
            try {
                if (this.indexed) {
                    Object existingValue = this.field.get(bean);
                    Object collection = MappingUtils.prepareIndexedCollection(this.getPropertyType(), existingValue, value, this.index);
                    this.field.set(bean, collection);
                } else {
                    this.field.set(bean, value);
                }
            }
            catch (IllegalAccessException e) {
                MappingUtils.throwMappingException(e);
            }
        }

        @Override
        public Class<?> genericType() {
            Type type = this.field.getGenericType();
            return ReflectionUtils.determineGenericsType(type);
        }
    }
}

