/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.processors;

import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.MediaCollectionAdapter;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.RequestProcessor;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.WorkspaceManager;

public class MediaRequestProcessor
implements RequestProcessor {
    public ResponseContext process(RequestContext context, WorkspaceManager workspaceManager, CollectionAdapter collectionAdapter) {
        if (collectionAdapter == null) {
            return ProviderHelper.notfound(context);
        }
        return this.processMedia(context, collectionAdapter);
    }

    protected ResponseContext processMedia(RequestContext context, CollectionAdapter adapter) {
        String method = context.getMethod();
        if (adapter instanceof MediaCollectionAdapter) {
            MediaCollectionAdapter mcadapter = (MediaCollectionAdapter)adapter;
            if (method.equalsIgnoreCase("GET")) {
                return mcadapter.getMedia(context);
            }
            if (method.equalsIgnoreCase("PUT")) {
                return mcadapter.putMedia(context);
            }
            if (method.equalsIgnoreCase("DELETE")) {
                return mcadapter.deleteMedia(context);
            }
            if (method.equalsIgnoreCase("HEAD")) {
                return mcadapter.headMedia(context);
            }
            if (method.equalsIgnoreCase("OPTIONS")) {
                return mcadapter.optionsMedia(context);
            }
            return null;
        }
        return ProviderHelper.notallowed(context);
    }
}

