/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.orchestrator.server;

import java.net.InetSocketAddress;
import org.apache.airavata.cluster.monitoring.ClusterStatusMonitorJobScheduler;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.IServer;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.orchestrator.cpi.OrchestratorService;
import org.apache.airavata.orchestrator.server.OrchestratorServerHandler;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrchestratorServer
implements IServer {
    private static final Logger logger = LoggerFactory.getLogger(OrchestratorServer.class);
    private static final String SERVER_NAME = "Orchestrator Server";
    private static final String SERVER_VERSION = "1.0";
    private IServer.ServerStatus status;
    private TServer server;
    private ClusterStatusMonitorJobScheduler clusterStatusMonitorJobScheduler;

    public OrchestratorServer() {
        this.setStatus(IServer.ServerStatus.STOPPED);
    }

    public void StartOrchestratorServer(OrchestratorService.Processor<OrchestratorServerHandler> orchestratorServerHandlerProcessor) throws Exception {
        final int serverPort = Integer.parseInt(ServerSettings.getSetting((String)"orchestrator.server.port", (String)"8940"));
        try {
            TServerSocket serverTransport;
            String serverHost = ServerSettings.getSetting((String)"orchestrator.server.host", null);
            if (serverHost == null) {
                serverTransport = new TServerSocket(serverPort);
            } else {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(serverHost, serverPort);
                serverTransport = new TServerSocket(inetSocketAddress);
            }
            TThreadPoolServer.Args options = new TThreadPoolServer.Args((TServerTransport)serverTransport);
            options.minWorkerThreads = Integer.parseInt(ServerSettings.getSetting((String)"orchestrator.server.min.threads", (String)"30"));
            this.server = new TThreadPoolServer((TThreadPoolServer.Args)options.processor(orchestratorServerHandlerProcessor));
            new Thread(){

                @Override
                public void run() {
                    OrchestratorServer.this.server.serve();
                    OrchestratorServer.this.setStatus(IServer.ServerStatus.STARTING);
                    logger.info("Starting Orchestrator Server ... ");
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    while (!OrchestratorServer.this.server.isServing()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    if (OrchestratorServer.this.server.isServing()) {
                        OrchestratorServer.this.setStatus(IServer.ServerStatus.STARTED);
                        logger.info("Started Orchestrator Server on Port " + serverPort + " ...");
                    }
                }
            }.start();
        }
        catch (TTransportException e) {
            logger.error(e.getMessage());
            this.setStatus(IServer.ServerStatus.FAILED);
            logger.error("Failed to start Orchestrator server on port " + serverPort + " ...");
        }
    }

    public void startClusterStatusMonitoring() throws SchedulerException, ApplicationSettingsException {
        this.clusterStatusMonitorJobScheduler = new ClusterStatusMonitorJobScheduler();
        this.clusterStatusMonitorJobScheduler.scheduleClusterStatusMonitoring();
    }

    public static void main(String[] args) {
        try {
            new OrchestratorServer().start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void start() throws Exception {
        if (ServerSettings.enableClusterStatusMonitoring().booleanValue()) {
            this.startClusterStatusMonitoring();
        }
        this.setStatus(IServer.ServerStatus.STARTING);
        OrchestratorService.Processor orchestratorService = new OrchestratorService.Processor((OrchestratorService.Iface)new OrchestratorServerHandler());
        this.StartOrchestratorServer((OrchestratorService.Processor<OrchestratorServerHandler>)orchestratorService);
    }

    public void stop() throws Exception {
        if (this.server != null && this.server.isServing()) {
            this.setStatus(IServer.ServerStatus.STOPING);
            this.server.stop();
        }
    }

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void configure() throws Exception {
    }

    public IServer.ServerStatus getStatus() throws Exception {
        return this.status;
    }

    private void setStatus(IServer.ServerStatus stat) {
        this.status = stat;
        this.status.updateTime();
    }

    public String getName() {
        return SERVER_NAME;
    }

    public String getVersion() {
        return SERVER_VERSION;
    }
}

