/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Calendar;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.unigrids.x2006.x04.services.jms.TargetSystemReferenceDocument;
import org.unigrids.x2006.x04.services.reservation.ReservationPropertiesDocument;
import org.unigrids.x2006.x04.services.reservation.ReservationReferenceDocument;
import org.unigrids.x2006.x04.services.reservation.ReservationStatusType;
import org.unigrids.x2006.x04.services.reservation.StartTimeDocument;
import org.unigrids.x2006.x04.services.tss.SubmitDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ReservationClient
extends BaseUASClient {
    public ReservationClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
    }

    public ReservationClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public JobClient submit(SubmitDocument in) throws Exception {
        JobDefinitionType job = in.getSubmit().getJobDefinition();
        EndpointReferenceType tssEPR = this.getTSSEpr();
        TSSClient tss = new TSSClient(tssEPR.getAddress().getStringValue(), tssEPR, this.getSecurityConfiguration());
        ResourcesType rt = job.getJobDescription().getResources();
        if (rt == null) {
            rt = job.getJobDescription().addNewResources();
        }
        if (!rt.toString().contains("ReservationReference")) {
            job.getJobDescription().setResources(this.addReservationReference(rt));
        }
        return tss.submit(in);
    }

    public ResourcesType addReservationReference(ResourcesType resources) throws Exception {
        String resID = "<u6rr:ReservationReference xmlns:u6rr=\"http://www.unicore.eu/unicore/xnjs\">" + this.getReservationReference() + "</u6rr:ReservationReference>";
        XmlObject o = XmlObject.Factory.parse((String)resID);
        ResourcesDocument rd = ResourcesDocument.Factory.newInstance();
        rd.setResources(resources);
        WSUtilities.append(o, (XmlObject)rd);
        return rd.getResources();
    }

    public Calendar getStartTime() throws Exception {
        return this.getSingleResourceProperty(StartTimeDocument.class).getStartTime();
    }

    public String getReservationReference() throws Exception {
        return this.getSingleResourceProperty(ReservationReferenceDocument.class).getReservationReference();
    }

    public ResourcesDocument getResources() throws Exception {
        return this.getSingleResourceProperty(ResourcesDocument.class);
    }

    public ReservationStatusType.Enum getReservationStatus() throws Exception {
        return this.getResourcePropertiesDocument().getReservationProperties().getReservationStatus();
    }

    public String getReservationStatusDescription() throws Exception {
        return this.getResourcePropertiesDocument().getReservationProperties().getReservationStatusDescription();
    }

    public EndpointReferenceType getTSSEpr() throws Exception {
        return this.getSingleResourceProperty(TargetSystemReferenceDocument.class).getTargetSystemReference();
    }

    public ReservationPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return ReservationPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }
}

