/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Experiment;
import org.apache.airavata.registry.core.experiment.catalog.model.Project;
import org.apache.airavata.registry.core.experiment.catalog.model.ProjectUser;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProjectUserResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.Utils;
import org.apache.airavata.registry.core.experiment.catalog.resources.WorkerResource;
import org.apache.airavata.registry.core.experiment.catalog.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.ResultOrderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(ProjectResource.class);
    private String name;
    private String id;
    private String gatewayId;
    private WorkerResource worker;
    private String description;
    private Timestamp creationTime;

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        if (type == ResourceType.EXPERIMENT) {
            ExperimentResource experimentResource = new ExperimentResource();
            experimentResource.setGatewayExecutionId(this.gatewayId);
            experimentResource.setUserName(this.worker.getUser());
            experimentResource.setProjectId(this.id);
            return experimentResource;
        }
        if (type == ResourceType.PROJECT_USER) {
            ProjectUserResource pr = new ProjectUserResource();
            pr.setProjectId(this.id);
            pr.setUserName(this.worker.getUser());
            return pr;
        }
        logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for project resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            if (type == ResourceType.EXPERIMENT) {
                QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                generator.setParameter("experimentId", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
            } else if (type == ResourceType.PROJECT_USER) {
                QueryGenerator generator = new QueryGenerator("ProjectUser", new Object[0][]);
                generator.setParameter("userName", name);
                generator.setParameter("projectId", this.id);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
            } else {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for project resource.");
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            if (type == ResourceType.EXPERIMENT) {
                em = ExpCatResourceUtils.getEntityManager();
                em.getTransaction().begin();
                QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                generator.setParameter("experimentId", name);
                Query q = generator.selectQuery(em);
                Experiment experiment = (Experiment)q.getSingleResult();
                ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                em.getTransaction().commit();
                em.close();
                ExperimentResource experimentResource2 = experimentResource;
                return experimentResource2;
            }
            if (type == ResourceType.PROJECT_USER) {
                em = ExpCatResourceUtils.getEntityManager();
                em.getTransaction().begin();
                QueryGenerator generator = new QueryGenerator("ProjectUser", new Object[0][]);
                generator.setParameter("userName", name);
                generator.setParameter("projectId", this.id);
                Query q = generator.selectQuery(em);
                ProjectUser prUser = (ProjectUser)q.getSingleResult();
                ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.PROJECT_USER, prUser);
                em.getTransaction().commit();
                em.close();
                ExperimentResource experimentResource3 = experimentResource;
                return experimentResource3;
            }
            try {
                logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for project resource.");
            }
            catch (Exception e) {
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        ArrayList<ExperimentCatResource> resourceList;
        block13: {
            resourceList = new ArrayList<ExperimentCatResource>();
            EntityManager em = null;
            try {
                if (type == ResourceType.EXPERIMENT) {
                    em = ExpCatResourceUtils.getEntityManager();
                    em.getTransaction().begin();
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("projectId", this.id);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() != 0) {
                        for (Object result : results) {
                            Experiment experiment = (Experiment)result;
                            ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                            resourceList.add(experimentResource);
                        }
                    }
                    em.getTransaction().commit();
                    em.close();
                    break block13;
                }
                if (type == ResourceType.PROJECT_USER) {
                    em = ExpCatResourceUtils.getEntityManager();
                    em.getTransaction().begin();
                    QueryGenerator generator = new QueryGenerator("ProjectUser", new Object[0][]);
                    generator.setParameter("projectId", this.id);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() != 0) {
                        for (Object result : results) {
                            ProjectUser projectUser = (ProjectUser)result;
                            ProjectUserResource pr = (ProjectUserResource)Utils.getResource(ResourceType.PROJECT_USER, projectUser);
                            resourceList.add(pr);
                        }
                    }
                    em.getTransaction().commit();
                    em.close();
                    break block13;
                }
                logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for project resource.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
            finally {
                if (em != null && em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
            }
        }
        return resourceList;
    }

    public List<ExperimentCatResource> get(ResourceType type, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        ArrayList<ExperimentCatResource> resourceList;
        block15: {
            resourceList = new ArrayList<ExperimentCatResource>();
            EntityManager em = null;
            try {
                if (type == ResourceType.EXPERIMENT) {
                    List results;
                    em = ExpCatResourceUtils.getEntityManager();
                    em.getTransaction().begin();
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("projectId", this.id);
                    Query q = orderByIdentifier != null && resultOrderType != null && orderByIdentifier.equals("creationTime") ? generator.selectQuery(em, "creationTime", resultOrderType) : generator.selectQuery(em);
                    if (limit > 0 && offset >= 0) {
                        q.setFirstResult(offset);
                        q.setMaxResults(limit);
                    }
                    if ((results = q.getResultList()).size() != 0) {
                        for (Object result : results) {
                            Experiment experiment = (Experiment)result;
                            ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                            resourceList.add(experimentResource);
                        }
                    }
                    em.getTransaction().commit();
                    em.close();
                    break block15;
                }
                if (type == ResourceType.PROJECT_USER) {
                    List results;
                    em = ExpCatResourceUtils.getEntityManager();
                    em.getTransaction().begin();
                    QueryGenerator generator = new QueryGenerator("ProjectUser", new Object[0][]);
                    generator.setParameter("projectId", this.id);
                    Query q = orderByIdentifier != null && resultOrderType != null && orderByIdentifier.equals("creationTime") ? generator.selectQuery(em, "creationTime", resultOrderType) : generator.selectQuery(em);
                    if (limit > 0 && offset >= 0) {
                        q.setFirstResult(offset);
                        q.setMaxResults(limit);
                    }
                    if ((results = q.getResultList()).size() != 0) {
                        for (Object result : results) {
                            ProjectUser projectUser = (ProjectUser)result;
                            ProjectUserResource pr = (ProjectUserResource)Utils.getResource(ResourceType.PROJECT_USER, projectUser);
                            resourceList.add(pr);
                        }
                    }
                    em.getTransaction().commit();
                    em.close();
                    break block15;
                }
                logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for project resource.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
            finally {
                if (em != null && em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            Project existingProject = (Project)em.find(Project.class, (Object)this.id);
            em.close();
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Project project = new Project();
            project.setProjectId(this.id);
            project.setProjectName(this.name);
            project.setGatewayId(this.gatewayId);
            project.setUserName(this.worker.getUser());
            project.setDescription(this.description);
            project.setCreationTime(this.creationTime);
            if (existingProject != null) {
                existingProject.setProjectName(this.name);
                existingProject.setGatewayId(this.gatewayId);
                existingProject.setUserName(this.worker.getUser());
                existingProject.setDescription(this.description);
                existingProject.setCreationTime(this.creationTime);
                em.merge((Object)existingProject);
            } else {
                em.persist((Object)project);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkerResource getWorker() {
        return this.worker;
    }

    public void setWorker(WorkerResource worker) {
        this.worker = worker;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public boolean isExperimentExists(String experimentId) throws RegistryException {
        return this.isExists(ResourceType.EXPERIMENT, experimentId);
    }

    public ExperimentResource createExperiment(String experimentId) throws RegistryException {
        ExperimentResource experimentResource = (ExperimentResource)this.create(ResourceType.EXPERIMENT);
        experimentResource.setExperimentId(experimentId);
        return experimentResource;
    }

    public ExperimentResource getExperiment(String experimentId) throws RegistryException {
        return (ExperimentResource)this.get(ResourceType.EXPERIMENT, experimentId);
    }

    public List<ExperimentResource> getExperiments() throws RegistryException {
        List<ExperimentCatResource> list = this.get(ResourceType.EXPERIMENT);
        ArrayList<ExperimentResource> result = new ArrayList<ExperimentResource>();
        for (ExperimentCatResource resource : list) {
            result.add((ExperimentResource)resource);
        }
        return result;
    }

    public List<ExperimentResource> getExperiments(int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        List<ExperimentCatResource> list = this.get(ResourceType.EXPERIMENT, limit, offset, orderByIdentifier, resultOrderType);
        ArrayList<ExperimentResource> result = new ArrayList<ExperimentResource>();
        for (ExperimentCatResource resource : list) {
            result.add((ExperimentResource)resource);
        }
        return result;
    }

    public void removeExperiment(String experimentId) throws RegistryException {
        this.remove(ResourceType.EXPERIMENT, experimentId);
    }

    public List<ProjectUserResource> getProjectUserList() throws RegistryException {
        List<ExperimentCatResource> resources = this.get(ResourceType.PROJECT_USER);
        ArrayList<ProjectUserResource> projectUserResources = new ArrayList<ProjectUserResource>();
        if (resources != null && !resources.isEmpty()) {
            for (ExperimentCatResource r : resources) {
                projectUserResources.add((ProjectUserResource)r);
            }
        }
        return projectUserResources;
    }
}

