/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task.utils.bes;

import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.impl.task.utils.bes.ApplicationProcessor;
import org.apache.airavata.gfac.impl.task.utils.bes.JSDLUtils;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UASDataStagingProcessor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public static void generateDataStagingElements(JobDefinitionType value, ProcessContext context, String smsUrl) throws Exception {
        smsUrl = "BFT:" + smsUrl;
        if (context.getProcessModel().getProcessOutputs().size() > 0) {
            UASDataStagingProcessor.buildDataStagingFromInputContext(context, value, smsUrl);
        }
        if (context.getProcessModel().getProcessOutputs().size() > 0) {
            UASDataStagingProcessor.buildFromOutputContext(context, value, smsUrl);
        }
    }

    private static void createInURISMSElement(JobDefinitionType value, String smsUrl, String uri, boolean useSMS) throws Exception {
        String fileName = new File(uri).getName();
        if (useSMS && uri.startsWith("file:")) {
            uri = smsUrl + "#/" + fileName;
        }
        JSDLUtils.addDataStagingSourceElement(value, uri, null, fileName);
    }

    private static void createStdOutURIs(JobDefinitionType value, ProcessContext context, String smsUrl, boolean isUnicore) throws Exception {
        if (isUnicore) {
            String scriptExitCodeFName = "UNICORE_SCRIPT_EXIT_CODE";
            String scriptExitCode = smsUrl + "#/output/" + scriptExitCodeFName;
            JSDLUtils.addDataStagingTargetElement(value, null, scriptExitCodeFName, null);
        }
        if (!isUnicore) {
            String stdout = ApplicationProcessor.getApplicationStdOut(value, context);
            String stderr = ApplicationProcessor.getApplicationStdErr(value, context);
            String stdoutFileName = stdout == null || stdout.equals("") ? "stdout" : stdout;
            String stdoutURI = smsUrl + "#/output/" + stdoutFileName;
            JSDLUtils.addDataStagingTargetElement(value, null, stdoutFileName, null);
            String stderrFileName = stdout == null || stderr.equals("") ? "stderr" : stderr;
            String stderrURI = smsUrl + "#/output/" + stderrFileName;
            JSDLUtils.addDataStagingTargetElement(value, null, stderrFileName, null);
        }
    }

    private static void createOutStringElements(JobDefinitionType value, String smsUrl, String prmValue) throws Exception {
        if (prmValue == null || "".equals(prmValue)) {
            return;
        }
        String finalSMSPath = smsUrl + "#/output/" + prmValue;
        JSDLUtils.addDataStagingTargetElement(value, null, prmValue, null);
    }

    private static void createOutURIElement(JobDefinitionType value, String prmValue) throws Exception {
        String fileName = new File(prmValue.toString()).getName();
        JSDLUtils.addDataStagingTargetElement(value, null, fileName, prmValue);
    }

    private static JobDefinitionType buildFromOutputContext(ProcessContext context, JobDefinitionType value, String smsUrl) throws Exception {
        List applicationOutputs = context.getProcessModel().getProcessOutputs();
        if (applicationOutputs != null && !applicationOutputs.isEmpty()) {
            for (OutputDataObjectType output : applicationOutputs) {
                if ("".equals(output.getValue()) || output.getValue() == null || !output.getType().equals((Object)DataType.URI)) continue;
                UASDataStagingProcessor.createOutURIElement(value, output.getValue());
            }
        }
        return value;
    }

    private static void buildDataStagingFromInputContext(ProcessContext context, JobDefinitionType value, String smsUrl) throws Exception {
        Comparator<InputDataObjectType> inputOrderComparator = new Comparator<InputDataObjectType>(){

            @Override
            public int compare(InputDataObjectType inputDataObjectType, InputDataObjectType t1) {
                return inputDataObjectType.getInputOrder() - t1.getInputOrder();
            }
        };
        TreeSet<InputDataObjectType> sortedInputSet = new TreeSet<InputDataObjectType>(inputOrderComparator);
        for (InputDataObjectType input : context.getProcessModel().getProcessInputs()) {
            sortedInputSet.add(input);
        }
        if (sortedInputSet != null && !sortedInputSet.isEmpty()) {
            for (InputDataObjectType input : sortedInputSet) {
                if ("".equals(input.getValue()) || input.getValue() == null) continue;
                if (input.getType().equals((Object)DataType.URI)) {
                    UASDataStagingProcessor.createInURISMSElement(value, smsUrl, input.getValue(), true);
                    continue;
                }
                if (input.getType().equals((Object)DataType.STRING) && input.isDataStaged()) {
                    UASDataStagingProcessor.createInURISMSElement(value, smsUrl, input.getValue(), false);
                    continue;
                }
                if (input.getType().equals((Object)DataType.STRING) && !input.isDataStaged()) {
                    ApplicationProcessor.addApplicationArgument(value, context, input.getValue());
                    continue;
                }
                if (!input.getType().equals((Object)DataType.FLOAT) && !input.getType().equals((Object)DataType.INTEGER) || input.getName().equals("NumberOfProcesses") || input.getName().equals("ProcessesPerHost")) continue;
                ApplicationProcessor.addApplicationArgument(value, context, String.valueOf(input.getValue()));
            }
        }
    }

    public static boolean isUnicoreEndpoint(ProcessContext context) {
        return context.getJobSubmissionProtocol().equals((Object)JobSubmissionProtocol.UNICORE);
    }
}

