/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.job;

import org.apache.airavata.model.status.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobUtil {
    private static final Logger log = LoggerFactory.getLogger(JobUtil.class);

    public static JobState getJobState(String status) {
        log.info("parsing the job status returned : " + status);
        if (status != null) {
            if ("C".equals(status) || "CD".equals(status) || "E".equals(status) || "CG".equals(status) || "DONE".equals(status)) {
                return JobState.COMPLETE;
            }
            if ("Q".equals(status) || "qw".equals(status) || "PEND".equals(status)) {
                return JobState.QUEUED;
            }
            if ("R".equals(status) || "CF".equals(status) || "r".equals(status) || "RUN".equals(status)) {
                return JobState.ACTIVE;
            }
            if ("W".equals(status) || "PD".equals(status)) {
                return JobState.QUEUED;
            }
            if ("S".equals(status) || "PSUSP".equals(status) || "USUSP".equals(status) || "SSUSP".equals(status)) {
                return JobState.SUSPENDED;
            }
            if ("CA".equals(status)) {
                return JobState.CANCELED;
            }
            if ("F".equals(status) || "NF".equals(status) || "TO".equals(status) || "EXIT".equals(status)) {
                return JobState.FAILED;
            }
            if ("PR".equals(status) || "Er".equals(status)) {
                return JobState.FAILED;
            }
            if ("U".equals(status) || "UNKWN".equals(status)) {
                return JobState.UNKNOWN;
            }
        }
        return JobState.UNKNOWN;
    }
}

