/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;

public final class ParameterUtil {
    private ParameterUtil() {
    }

    public static Parameter createParameter(OMElement parameterElement) throws AxisFault {
        if (parameterElement.getParent() instanceof OMDocument) {
            parameterElement.detach();
        }
        Parameter parameter = new Parameter();
        parameter.setParameterElement(parameterElement);
        OMAttribute paraName = parameterElement.getAttribute(new QName("name"));
        if (paraName == null) {
            throw new AxisFault(Messages.getMessage((String)"badparaagu"));
        }
        parameter.setName(paraName.getAttributeValue());
        OMElement paraValue = parameterElement.getFirstElement();
        if (paraValue != null) {
            parameter.setValue((Object)parameterElement);
            parameter.setParameterType(2);
        } else {
            String paratextValue = parameterElement.getText();
            parameter.setValue((Object)paratextValue);
            parameter.setParameterType(1);
        }
        OMAttribute paraLocked = parameterElement.getAttribute(new QName("locked"));
        parameter.setParameterElement(parameterElement);
        if (paraLocked != null) {
            String lockedValue = paraLocked.getAttributeValue();
            if ("true".equals(lockedValue)) {
                parameter.setLocked(true);
            } else {
                parameter.setLocked(false);
            }
        }
        return parameter;
    }

    public static Parameter createParameter(String name, String value) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace ns = fac.createOMNamespace("", "");
        OMElement paramEle = fac.createOMElement("parameter", ns);
        if (name == null) {
            throw new AxisFault("Parameter name is madatory.");
        }
        paramEle.addAttribute("name", name, ns);
        if (value != null && value.length() != 0) {
            paramEle.setText(value);
        }
        return ParameterUtil.createParameter(paramEle);
    }

    public static Parameter createParameter(String name, String value, boolean locked) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace ns = fac.createOMNamespace("", "");
        OMElement paramEle = fac.createOMElement("parameter", ns);
        if (name == null) {
            throw new AxisFault("Parameter name is madatory.");
        }
        paramEle.addAttribute("name", name, ns);
        if (locked) {
            paramEle.addAttribute("locked", "true", ns);
        }
        if (value != null && value.length() != 0) {
            paramEle.setText(value);
        }
        return ParameterUtil.createParameter(paramEle);
    }
}

