/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports.util;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.core.transports.util.RequestProcessorUtil;
import org.wso2.carbon.core.util.GhostDispatcherUtils;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public abstract class AbstractWsdlProcessor
implements HttpGetRequestProcessor {
    protected void printWSDL(ConfigurationContext configurationContext, String serviceName, CarbonHttpResponse response, WSDLPrinter wsdlPrinter) throws IOException {
        AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
        AxisService axisService = axisConfig.getServiceForActivation(serviceName);
        if (axisService == null && (axisService = TenantAxisUtils.getAxisService(serviceName, configurationContext)) != null) {
            axisConfig = TenantAxisUtils.getTenantAxisConfiguration(TenantAxisUtils.getTenantDomain(serviceName), configurationContext);
        }
        if (GhostDeployerUtils.isGhostService((AxisService)axisService) && axisConfig != null) {
            String serviceGroupName = null;
            if (axisService != null) {
                serviceGroupName = axisService.getAxisServiceGroup() != null ? axisService.getAxisServiceGroup().getServiceGroupName() : axisService.getName();
            }
            if (CarbonUtils.isDepSyncEnabled() && CarbonUtils.isWorkerNode() && GhostDeployerUtils.isPartialUpdateEnabled()) {
                GhostDispatcherUtils.handleDepSynchUpdate(axisConfig, axisService);
            }
            axisService = GhostDeployerUtils.deployActualService((AxisConfiguration)axisConfig, (AxisService)axisService);
            GhostDispatcherUtils.deployServiceMetaFile(serviceGroupName, axisConfig);
        }
        String hideAdminServiceWSDLs = CarbonCoreDataHolder.getInstance().getServerConfigurationService().getFirstProperty("Axis2Config.HideAdminServiceWSDLs");
        OutputStream outputStream = response.getOutputStream();
        if (axisService != null) {
            if (SystemFilter.isFilteredOutService(axisService) && "true".equals(hideAdminServiceWSDLs)) {
                response.setError(403, "Access to service metadata for service: " + serviceName + " has been forbidden");
                return;
            }
            if (!RequestProcessorUtil.canExposeServiceMetadata(axisService)) {
                response.setError(403, "Access to service metadata for service: " + serviceName + " has been forbidden");
                return;
            }
            if (!axisService.isActive()) {
                response.addHeader("Content-Type", "text/html");
                outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot display WSDL document.</h4>").getBytes());
                outputStream.flush();
            } else {
                response.addHeader("Content-Type", "text/xml");
                wsdlPrinter.printWSDL(axisService);
            }
        } else {
            response.addHeader("Content-Type", "text/html");
            outputStream.write(("<h4>Service " + serviceName + " not found. Cannot display WSDL document.</h4>").getBytes());
            response.setError(404);
            outputStream.flush();
        }
    }

    protected boolean checkForAnnotation(CarbonHttpRequest request) {
        String parameter = request.getParameter("annotation");
        return parameter != null && parameter.length() != 0 && parameter.equals("true");
    }

    protected String getImportedWSDL(CarbonHttpRequest request, String paramName) {
        String paramValue = request.getParameter(paramName);
        if (paramValue != null && paramValue.length() != 0) {
            return paramValue;
        }
        return "";
    }

    protected static interface WSDLPrinter {
        public void printWSDL(AxisService var1) throws IOException;
    }
}

