/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc.mapping;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import javax.sql.DataSource;
import org.compass.gps.device.jdbc.JdbcGpsDeviceException;
import org.compass.gps.device.jdbc.JdbcUtils;
import org.compass.gps.device.jdbc.mapping.AutoGenerateMapping;
import org.compass.gps.device.jdbc.mapping.ColumnToPropertyMapping;
import org.compass.gps.device.jdbc.mapping.IdColumnToPropertyMapping;
import org.compass.gps.device.jdbc.mapping.ResultSetToResourceMapping;
import org.compass.gps.device.jdbc.mapping.VersionColumnMapping;

public class TableToResourceMapping
extends ResultSetToResourceMapping
implements AutoGenerateMapping {
    private String tableName;

    public TableToResourceMapping() {
    }

    public TableToResourceMapping(String tableName, String alias) {
        this.setAlias(alias);
        this.tableName = tableName;
    }

    public void generateMappings(DataSource dataSource) throws JdbcGpsDeviceException {
        if (this.idMappingsSize() == 0) {
            this.generateIdMappings(dataSource);
        }
        if (this.getSelectQuery() == null) {
            this.generateSelectQuery(dataSource);
        }
        if (this.getVersionQuery() == null && this.supportsVersioning()) {
            this.generateVersionQuery(dataSource);
        }
    }

    private void generateIdMappings(DataSource dataSource) throws JdbcGpsDeviceException {
        Connection con = JdbcUtils.getConnection(dataSource);
        ResultSet pks = null;
        try {
            DatabaseMetaData metaData = con.getMetaData();
            pks = metaData.getPrimaryKeys(null, null, this.getTableName().toUpperCase());
            while (pks.next()) {
                String pkColumnName = pks.getString("COLUMN_NAME");
                this.addIdMapping(new IdColumnToPropertyMapping(pkColumnName, pkColumnName));
            }
        }
        catch (SQLException e) {
            try {
                throw new JdbcGpsDeviceException("Failed to fetch primary keys for table [" + this.getTableName() + "]", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(pks);
                JdbcUtils.closeConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(pks);
        JdbcUtils.closeConnection(con);
    }

    private void generateSelectQuery(DataSource dataSource) {
        if (this.isIndexUnMappedColumns()) {
            this.setSelectQuery("select * from " + this.getTableName());
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("select ");
            boolean first = true;
            Iterator idIt = this.idMappingsIt();
            while (idIt.hasNext()) {
                ColumnToPropertyMapping idMapping = (ColumnToPropertyMapping)idIt.next();
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                if (idMapping.isUsingColumnIndex()) {
                    throw new IllegalArgumentException("When mapping and not using the indexUnMappedColumns, must specify id column name and not column index");
                }
                sb.append(idMapping.getColumnName());
            }
            Iterator dataIt = this.dataMappingsIt();
            while (dataIt.hasNext()) {
                ColumnToPropertyMapping dataMapping = (ColumnToPropertyMapping)dataIt.next();
                sb.append(", ");
                if (dataMapping.isUsingColumnIndex()) {
                    throw new IllegalArgumentException("When mapping and not using the indexUnMappedColumns, must specify id column name and not column index");
                }
                sb.append(dataMapping.getColumnName());
            }
            Iterator verIt = this.versionMappingsIt();
            while (verIt.hasNext()) {
                VersionColumnMapping verMapping = (VersionColumnMapping)verIt.next();
                sb.append(", ");
                if (verMapping.isUsingColumnIndex()) {
                    throw new IllegalArgumentException("When mapping version column to a table, must specify version column name and not column index");
                }
                sb.append(verMapping.getColumnName());
            }
            sb.append(" from ");
            sb.append(this.getTableName());
            this.setSelectQuery(sb.toString());
        }
    }

    private void generateVersionQuery(DataSource dataSource) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        boolean first = true;
        Iterator idIt = this.idMappingsIt();
        while (idIt.hasNext()) {
            IdColumnToPropertyMapping idMapping = (IdColumnToPropertyMapping)idIt.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(idMapping.getColumnNameForVersion());
        }
        Iterator verIt = this.versionMappingsIt();
        while (verIt.hasNext()) {
            VersionColumnMapping verMapping = (VersionColumnMapping)verIt.next();
            sb.append(", ");
            if (verMapping.isUsingColumnIndex()) {
                throw new IllegalArgumentException("When mapping version column to a table, must specify version column name and not column index");
            }
            sb.append(verMapping.getColumnName());
        }
        sb.append(" from ");
        sb.append(this.getTableName());
        this.setVersionQuery(sb.toString());
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String toString() {
        return "Table[" + this.tableName + "] " + super.toString();
    }
}

