/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class CreateSessionResponseMessage
extends PacketImpl {
    private int serverVersion;

    public CreateSessionResponseMessage(int serverVersion) {
        super((byte)31);
        this.serverVersion = serverVersion;
    }

    public CreateSessionResponseMessage() {
        super((byte)31);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.serverVersion);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.serverVersion = buffer.readInt();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.serverVersion);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateSessionResponseMessage)) {
            return false;
        }
        CreateSessionResponseMessage other = (CreateSessionResponseMessage)obj;
        return this.serverVersion == other.serverVersion;
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", serverVersion=" + this.serverVersion);
        return sb.toString();
    }
}

