/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;

public class SetHeadersProcessor
extends BaseProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final List<Expression> headerNames;
    private final List<Expression> expressions;

    public SetHeadersProcessor(List<Expression> headerNames, List<Expression> expressions) {
        this.headerNames = headerNames;
        this.expressions = expressions;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            int headerIndex = 0;
            for (Expression expression : this.expressions) {
                Object newHeader = expression.evaluate(exchange, Object.class);
                if (exchange.getException() != null) {
                    callback.done(true);
                    return true;
                }
                Message message = exchange.getMessage();
                String key = (String)this.headerNames.get(headerIndex++).evaluate(exchange, String.class);
                message.setHeader(key, newHeader);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("setHeaders[");
        int headerIndex = 0;
        for (Expression expression : this.expressions) {
            if (headerIndex > 0) {
                sb.append("; ");
            }
            sb.append(this.headerNames.get(headerIndex++).toString());
            sb.append(", ");
            sb.append(expression.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public List<Expression> getHeaderNames() {
        return this.headerNames;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }
}

