/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.models.LogisticDialogSplitModel;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class LogisticDialogSplit
extends JDialog
implements ActionListener,
FocusListener {
    private JRadioButton cut;
    private JComboBox cutDirection;
    private JButton remove;
    private JScrollPane levelsScroller;
    private JRadioButton expression;
    private JList suc;
    private JScrollPane sucScroller;
    private JSeparator sep1;
    private JPanel okayCancelPanel;
    private JTextField expr;
    private JPanel sucPanel;
    private JList levels;
    private JButton add;
    private JPanel levelsPanel;
    private JRadioButton defineLevels;
    private JSeparator sep;
    private JTextField cutValue;
    private LogisticDialogSplitModel model;

    public LogisticDialogSplit(JDialog jDialog, LogisticDialogSplitModel logisticDialogSplitModel) {
        super(jDialog);
        this.setModal(true);
        this.initGUI();
        this.setModel(logisticDialogSplitModel);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.cut = new JRadioButton();
            this.getContentPane().add(this.cut);
            this.cut.setText("Success");
            this.cut.setBounds(12, 12, 83, 18);
            Serializable serializable = new DefaultComboBoxModel<String>(new String[]{">", "<"});
            this.cutDirection = new JComboBox();
            this.getContentPane().add(this.cutDirection);
            this.cutDirection.setModel(serializable);
            this.cutDirection.setBounds(100, 11, 80, 25);
            this.cutValue = new JTextField();
            this.getContentPane().add(this.cutValue);
            this.cutValue.setBounds(180, 11, 75, 21);
            this.cutValue.addFocusListener(this);
            this.sep = new JSeparator();
            this.getContentPane().add(this.sep);
            this.sep.setBounds(129, 44, 137, 10);
            this.defineLevels = new JRadioButton();
            this.getContentPane().add(this.defineLevels);
            this.defineLevels.setBounds(12, 113, 21, 17);
            this.levelsPanel = new JPanel();
            serializable = new BorderLayout();
            this.levelsPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add(this.levelsPanel);
            this.levelsPanel.setBounds(49, 54, 127, 140);
            this.levelsPanel.setBorder(BorderFactory.createTitledBorder("Levels"));
            this.levelsScroller = new JScrollPane();
            this.levelsPanel.add((Component)this.levelsScroller, "Center");
            DefaultListModel defaultListModel = new DefaultListModel();
            this.levels = new DJList();
            this.levelsScroller.setViewportView(this.levels);
            this.levels.setModel(defaultListModel);
            this.levels.addFocusListener(this);
            this.add = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
            this.getContentPane().add(this.add);
            this.add.setBounds(191, 87, 38, 38);
            this.add.addFocusListener(this);
            this.remove = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
            this.getContentPane().add(this.remove);
            this.remove.setBounds(191, 130, 38, 38);
            this.remove.addFocusListener(this);
            this.sucPanel = new JPanel();
            serializable = new BorderLayout();
            this.sucPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add(this.sucPanel);
            this.sucPanel.setBounds(240, 54, 127, 140);
            this.sucPanel.setBorder(BorderFactory.createTitledBorder("Success:"));
            this.sucPanel.addFocusListener(this);
            this.sucScroller = new JScrollPane();
            this.sucPanel.add((Component)this.sucScroller, "Center");
            defaultListModel = new DefaultListModel();
            this.suc = new DJList();
            this.sucScroller.setViewportView(this.suc);
            this.suc.setModel(defaultListModel);
            this.suc.addFocusListener(this);
            this.expression = new JRadioButton();
            this.getContentPane().add(this.expression);
            this.expression.setText("Custom Expression:");
            this.expression.setBounds(12, 219, 180, 18);
            this.expr = new JTextField();
            this.getContentPane().add(this.expr);
            this.expr.setBounds(200, 218, 103, 21);
            this.expr.addFocusListener(this);
            this.okayCancelPanel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancelPanel);
            this.okayCancelPanel.setBounds(171, 258, 190, 36);
            this.sep1 = new JSeparator();
            this.getContentPane().add(this.sep1);
            this.sep1.setBounds(129, 205, 137, 10);
            this.setSize(381, 340);
            this.setTitle("Define Success");
            serializable = new ButtonGroup();
            ((ButtonGroup)serializable).add(this.cut);
            ((ButtonGroup)serializable).add(this.defineLevels);
            ((ButtonGroup)serializable).add(this.expression);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setModel(LogisticDialogSplitModel logisticDialogSplitModel) {
        int n;
        this.model = logisticDialogSplitModel;
        DefaultListModel defaultListModel = (DefaultListModel)this.levels.getModel();
        defaultListModel.removeAllElements();
        for (n = 0; n < logisticDialogSplitModel.levels.size(); ++n) {
            defaultListModel.addElement(logisticDialogSplitModel.levels.get(n));
        }
        defaultListModel = (DefaultListModel)this.suc.getModel();
        defaultListModel.removeAllElements();
        for (n = 0; n < logisticDialogSplitModel.suc.size(); ++n) {
            defaultListModel.addElement(logisticDialogSplitModel.suc.get(n));
        }
        this.cutValue.setText(logisticDialogSplitModel.cutValue);
        this.expr.setText(logisticDialogSplitModel.expr);
        if (logisticDialogSplitModel.which == 1) {
            this.cut.setSelected(true);
        } else if (logisticDialogSplitModel.which == 2) {
            this.defineLevels.setSelected(true);
        } else {
            this.expression.setSelected(true);
        }
        this.cutDirection.setSelectedItem(logisticDialogSplitModel.cutDirection);
        n = logisticDialogSplitModel.levels.getSize() == 0 && logisticDialogSplitModel.suc.getSize() == 0 ? 1 : 0;
        this.defineLevels.setEnabled(n == 0);
        this.levels.setEnabled(n == 0);
        this.add.setEnabled(n == 0);
        this.remove.setEnabled(n == 0);
        this.suc.setEnabled(n == 0);
        this.cut.setEnabled(logisticDialogSplitModel.isNumeric);
        this.cutValue.setEnabled(logisticDialogSplitModel.isNumeric);
        this.cutDirection.setEnabled(logisticDialogSplitModel.isNumeric);
    }

    public boolean updateModel() {
        if (this.cut.isSelected()) {
            try {
                Double.parseDouble(this.cutValue.getText());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "The cut value must be a number");
                this.cutValue.setText("");
                return false;
            }
        }
        if (this.defineLevels.isSelected() && (this.levels.getModel().getSize() == 0 || this.suc.getModel().getSize() == 0)) {
            JOptionPane.showMessageDialog(this, "Success must be a non-empty list of levels, and cannot contain all of the levels");
            return false;
        }
        this.model.levels = (DefaultListModel)this.levels.getModel();
        this.model.suc = (DefaultListModel)this.suc.getModel();
        this.model.which = this.cut.isSelected() ? 1 : (this.defineLevels.isSelected() ? 2 : 3);
        this.model.expr = "";
        this.model.cutValue = "";
        if (this.model.which == 1) {
            this.model.cutValue = this.cutValue.getText();
            this.model.cutDirection = (String)this.cutDirection.getSelectedItem();
        }
        if (this.model.which == 3) {
            this.model.expr = this.expr.getText();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            String string;
            block7: {
                string = actionEvent.getActionCommand();
                if (string != "OK") break block7;
                if (!this.updateModel()) break block8;
                this.dispose();
                break block8;
            }
            if (string == "Cancel") {
                this.dispose();
            } else if (string == "Add") {
                Object[] objectArray = this.levels.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((DefaultListModel)this.levels.getModel()).removeElement(objectArray[i]);
                    ((DefaultListModel)this.suc.getModel()).addElement(objectArray[i]);
                }
            } else if (string == "Remove") {
                Object[] objectArray = this.suc.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((DefaultListModel)this.suc.getModel()).removeElement(objectArray[i]);
                    ((DefaultListModel)this.levels.getModel()).addElement(objectArray[i]);
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.cutValue) {
            this.cut.setSelected(true);
        } else if (object == this.levels || object == this.suc || object == this.add || object == this.remove) {
            this.defineLevels.setSelected(true);
        } else if (object == this.expr) {
            this.expression.setSelected(true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

